/*
 * Legato is a configurable, lightweight web mapping client that can be
 * easily embedded into web pages and portals, CMS and individual web
 * applications. Legato is implemented in JavaScript and based on the
 * popular open source library OpenLayers.
 *
 * Copyright (C) 2010  disy Informationssysteme GmbH, http://www.disy.net
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

/*
 * Legato is a configurable, lightweight web mapping client that can be
 * easily embedded into web pages and portals, CMS and individual web
 * applications. Legato is implemented in JavaScript and based on the
 * popular open source library OpenLayers.
 *
 * Copyright (C) 2010  disy Informationssysteme GmbH, http://www.disy.net
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

LegatoJQuery.Popup.DialogPopup = OpenLayers.Class(
  Legato.Popup,
  {
    closeCallback : null,

    initialize: function(options){
      if(Legato.Lang.ObjectUtils.isNullOrUndefined(jQuery)){
        throw new Legato.Lang.Exception('jQuery is not found');
      }
      Legato.Popup.prototype.initialize.apply(
        this, [options]
      );
      this.dialog = jQuery('<div></div>')
      .html('')
      .dialog({
        autoOpen: false,
        close: OpenLayers.Function.bind(this.closeDialog, this)
      });
      this.configureDialog();
    },

    configureDialog: function(){
      this.dialog.dialog( 'option', 'title', this.title );
      if(!Legato.Lang.ObjectUtils.isNullOrUndefined(this.maxHeight)){
        this.dialog.dialog( 'option', 'maxHeight', this.maxHeight );
      }

      if(!Legato.Lang.ObjectUtils.isNullOrUndefined(this.height)) {
        this.dialog.dialog( 'option', 'height', this.height );
      }

      if(!Legato.Lang.ObjectUtils.isNullOrUndefined(this.width)) {
        this.dialog.dialog( 'option', 'width', this.width );
      }


      if(!Legato.Lang.ObjectUtils.isNullOrUndefined(this.size)){
        this.dialog.dialog( 'option', 'height', this.size.h );
        this.dialog.dialog( 'option', 'width', this.size.w );
      }

      this.setPosition(this.position);

      if(!Legato.Lang.ObjectUtils.isNullOrUndefined(this.zIndex)){
        this.dialog.dialog( 'option', 'zIndex', this.zIndex );
      }
    },

    openUrl : function(url) {
      this.dialog.html("<iframe id='modalIframeId' width='100%' height='100%' marginWidth='0' marginHeight='0' frameBorder='0' scrolling='auto' src='" +
          url
          + "'>Your browser does not support iFrames</iframe>");
      this.dialog.dialog('open');
    },

    open : function(element, id, closeCallback) {
      this.closeCallback = closeCallback;
      if (id !== null) {
        this.dialog.attr('id', id);
      }
      this.dialog.html(element);
      this.dialog.dialog('open');
    },

    close : function() {
      this.dialog.dialog();
      this.dialog.dialog('close');
    },

    closeDialog : function(event) {
      if (Legato.Lang.Function.isInstance(this.closeCallback)) {
        this.closeCallback(event);
      }
    },

    CLASS_NAME : 'LegatoJQuery.Popup.DialogPopup'
  }
);

/**
 * Component: ljqpo:DialogPopup
 *
 * The DialogPopup control creates and displays text or urls using the jQuery library.
 *
 * See also:
 * - <ljqpo> namespace
 */
LegatoJQuery.Popup.DialogPopup.Bean = Legato.Popup.Bean.Extend('LegatoJQuery.Popup.DialogPopup',
LegatoJQuery.Popup.QName('DialogPopup'),
//
{
  _constructor : LegatoJQuery.Popup.DialogPopup
});
