/*
 * Legato is a configurable, lightweight web mapping client that can be
 * easily embedded into web pages and portals, CMS and individual web
 * applications. Legato is implemented in JavaScript and based on the
 * popular open source library OpenLayers.
 *
 * Copyright (C) 2010  disy Informationssysteme GmbH, http://www.disy.net
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

/**
 * @author $Author: nedkov $
 * @base Legato.Control
 * @requires Legato/Control.js
 */

/**
 * Class: ControlContainer
 *
 * Inherits from: - <Legato.Control>
 */
LegatoJQuery.Control.ControlContainer = OpenLayers.Class(Legato.Control.ControlContainer,
{

  onHoverPanelDiv : function(panel_div){
    var j_panel_div = jQuery(panel_div);
    if (Legato.Util.Browser.isTouchCapable()){
        j_panel_div.bind('touchstart', function() {
            jQuery(this).children().toggle();
        });
    } else {
      var config = {
          over: function() {
            jQuery(this).children().show();
          },
          timeout: 300,
          out:  function() {
            jQuery(this).children().hide();
          }
      };

      j_panel_div.click(function() {
        jQuery(this).children().show();
      });
      j_panel_div.hoverIntent(config);
    }
  },

  CLASS_NAME: 'LegatoJQuery.Control.ControlContainer'
});

/**
 * Structure: lc:ControlContainer
 * XML based config for a <Legato.Control.ControlContainer>.
 *
 * See Also:
 * - <Legato.Control>
 * - <Legato.Beans.BeanFactory>
 * - <QName>
 *
 * A valid config example for a ControlContainer would be:
 * (start code)
 * <ljqc:ControlContainer>
 *  <controls>
 *  </controls>
 * </ljqc:ControlContainer>
 * (end)
 */
LegatoJQuery.Control.ControlContainer.Bean = Legato.Control.ControlContainer.Bean.Extend(
    'LegatoJQuery.Control.ControlContainer',
    LegatoJQuery.Control.QName('ControlContainer'),
    {
      _constructor: LegatoJQuery.Control.ControlContainer
    }
  );
