/*
 * Legato is a configurable, lightweight web mapping client that can be
 * easily embedded into web pages and portals, CMS and individual web
 * applications. Legato is implemented in JavaScript and based on the
 * popular open source library OpenLayers.
 *
 * Copyright (C) 2010  disy Informationssysteme GmbH, http://www.disy.net
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

/*
 * File: OpenLayers.Layer.ArcIMS support
 */

/*
 * Class: OpenLayers.Layer.ArcIMS.ArcIMSLayer
 * Represents information of an ArcIMS layer
 */
OpenLayers.Layer.ArcIMS.ArcIMSLayer = Legato.Lang.Class({
  /*
   * Property: id
   * {String} the id of the layer
   */
  id: null,

  /*
   * Property: visible
   * {Boolean} whether the layer is visible
   */
  visible: true,

  initialize : function() {
    //do nothing
  },

  toString: function(){
    return this.CLASS_NAME + ': id:' + this.id;
  },

  CLASS_NAME: 'OpenLayers.Layer.ArcIMS.ArcIMSLayer'

});

/*
 * Class: OpenLayers.Layer.ArcIMS.Background
 * Represents the background color of ArcIMS layers
 */
OpenLayers.Layer.ArcIMS.Background = Legato.Lang.Class({
  /*
   * Property: color
   * {<Legato.Lang.RGBColor>} the background color
   */
  color: null,

  /*
   * Property: transcolor
   * {<Legato.Lang.RGBColor>} the transparent color
   */
  transcolor: null,
  initialize : function() {
    //do nothing
  },
  toString: function(){
    return this.CLASS_NAME;
  },

  CLASS_NAME: 'OpenLayers.Layer.ArcIMS.Background'

});


OpenLayers.Layer.ArcIMS.NAMESPACE_URI = 'http://www.disy.net/legato/arcims';
OpenLayers.Layer.ArcIMS.PREFIX = 'ai';

OpenLayers.Layer.ArcIMS.QName = function(localPart) {
  return new Legato.XML.QName(OpenLayers.Layer.ArcIMS.NAMESPACE_URI, localPart,
      OpenLayers.Layer.ArcIMS.PREFIX);
};

/*
 * Structure: ai:ArcIMSLayer
 * XML based config for a <OpenLayers.Layer.ArcIMS.ArcIMSLayer>.
 *
 * See Also:
 * - <Legato.Beans.BeanFactory>
 * - <QName>
 *
 * A valid config example for an ArcIMSLayer would be:
 * (start code)
 * <ai:ArcIMSLayer id="1" visible="true" />
 * (end)
 */
OpenLayers.Layer.ArcIMS.ArcIMSLayer.Bean = Legato.Beans.Object.Extend('OpenLayers.Layer.ArcIMS.ArcIMSLayer',
//
    OpenLayers.Layer.ArcIMS.QName('ArcIMSLayer'),
    //
    {
      _constructor :OpenLayers.Layer.ArcIMS.ArcIMSLayer,
      constructorArguments : {
      },
      constructorOrder : [],
      fields : {
        /*
         * Property: id
         * {String} the id of the layer
         */
        id : Legato.Lang.String,

        /*
         * Property: visible
         * {Boolean} whether the layer is visible
         */
        visible : Legato.Lang.Boolean
      }
    });

/*
 * Structure: ai:Background
 * XML based config for a <OpenLayers.Layer.ArcIMS.Background>.
 *
 * See Also:
 * - <Legato.Beans.BeanFactory>
 * - <QName>
 *
 * A valid config example for a Background would be:
 * (start code)
 * <ai:Background>
 *   <color><ll:RGBColor r="255" g="255" b="255" /></color>
 *   <transcolor><ll:RGBColor r="255" g="255" b="255" /></transcolor>
 * </ai:Background>
 * (end)
 */
OpenLayers.Layer.ArcIMS.Background.Bean = Legato.Beans.Object.Extend('OpenLayers.Layer.ArcIMS.Background',
    //
        OpenLayers.Layer.ArcIMS.QName('Background'),
        //
        {
          _constructor :OpenLayers.Layer.ArcIMS.Background,
          constructorArguments : {
          },
          constructorOrder : [],
          fields : {
            /*
             * Property: color
             * {<Legato.Lang.RGBColor>} the background color
             */
            color : Legato.Lang.RGBColor,

            /*
             * Property: transcolor
             * {<Legato.Lang.RGBColor>} the transparent color
             */
            transcolor : Legato.Lang.RGBColor
          }
        });


/*
 * Structure: ESRI:ArcIMS extensions
 * XML based config for <OpenLayers.Layer.ArcIMS> extensions (service type: "ESRI:ArcIMS)".
 *
 * See Also:
 * - <Legato.Beans.BeanFactory>
 * - <QName>
 *
 * A valid config example for a Background would be:
 * (start code)
 * <Extension>
 *   <le:Extension xmlns="">
 *     <isBaseLayer>false</isBaseLayer>
 *      <background>
 *        <ai:Background>
 *          <color><ll:RGBColor r="255" g="255" b="255" /></color>
 *          <transcolor><ll:RGBColor r="255" g="255" b="255" /></transcolor>
 *        </ai:Background>
 *      </background>
 *      <layers>
 *        <ai:ArcIMSLayer id="1" visible="true" />
 *      </layers>
 *   </le:Extension>
 * </Extension>
 * (end)
 */
OpenLayers.Layer.ArcIMS.Bean = OpenLayers.Layer.Grid.Bean.Extend(
    'OpenLayers.Layer.ArcIMS',
    //
    Legato.OpenLayers.Layer.QName('ArcIMS'),
    //
    {
      //_constructor :OpenLayers.Layer.ArcIMS,
      factoryFunction:function(name, url, options)
      {
        if (Legato.Lang.ObjectUtils.exists(options) &&
            !Legato.Lang.ObjectUtils.exists(options.serviceName))
        {
          options.serviceName = name;
        }
        var layer = new OpenLayers.Layer.ArcIMS(name, url, options);
        return layer;
      },
      constructorArguments : {
        name :Legato.Lang.String,
        url :Legato.Lang.String
      },
      constructorOrder : [ 'name', 'url' ],
      options : {
        /*
         * Property: serviceName
         * {String} the name of the service (per default is the layer name)
         */
        serviceName :Legato.Lang.String,
        reproject :Legato.Lang.Boolean,
        encodeBBOX :Legato.Lang.Boolean,
        //transparent :Legato.Lang.Boolean,
        background: OpenLayers.Layer.ArcIMS.Background.Bean,
        featureCoordSys :Legato.Lang.String,
        filterCoordSys :Legato.Lang.String,
        layers : OpenLayers.Layer.ArcIMS.ArcIMSLayer.Bean.List(),
        async :Legato.Lang.Boolean
      }
    });

OpenLayers.Layer.ArcIMS.LayerFactory = Legato.Lang.Class(
//
    Legato.Format.ExtendedWMC.LayerFactory,
    //
    {
      layerType : OpenLayers.Layer.ArcIMS.Bean
    });

Legato.Format.ExtendedWMC.registerDefaultLayerFactory('ESRI:ArcIMS',
    new OpenLayers.Layer.ArcIMS.LayerFactory());