/*
 * Legato is a configurable, lightweight web mapping client that can be
 * easily embedded into web pages and portals, CMS and individual web
 * applications. Legato is implemented in JavaScript and based on the
 * popular open source library OpenLayers.
 *
 * Copyright (C) 2010  disy Informationssysteme GmbH, http://www.disy.net
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

Legato.OpenLayers.Control = {};
/**
 * Space: olc
 */
/**
 * URI: Namespace URI
 * http://www.openlayers.org/control
 */
Legato.OpenLayers.Control.NAMESPACE_URI = 'http://www.openlayers.org/control';
/**
 * Prefix: Default Prefix
 * olc
 */
Legato.OpenLayers.Control.PREFIX = 'olc';
Legato.OpenLayers.Control.QName = function(localPart) {
	return new Legato.XML.QName(Legato.OpenLayers.Control.NAMESPACE_URI,
			localPart, Legato.OpenLayers.Control.PREFIX);
};
Legato.Lang['OpenLayers.Control.TYPE'] = Legato.Lang.Integer.Enum(
		'OpenLayers.Control.TYPE', {
			'TYPE_BUTTON' : 1,
			'TYPE_TOGGLE' : 2,
			'TYPE_TOOL' : 3
		});
/**
 * Component: olc:Control
 * Abstract base component for OpenLayers Controls.
 * 
 * See also:
 * - <olc> namespace
 * - {<OpenLayers.Control>}
 * - <lc> namespace
 * - {<Legato.Control>}
 */
OpenLayers.Control.Bean = Legato.Beans.Object.Extend('OpenLayers.Control',
//
Legato.OpenLayers.QName('Control'),
//
{
	_constructor : OpenLayers.Control,
	options : {
		/**
		 * Element: id
		 * {String} id of the control.
		 */
		id : Legato.Lang.String,
		/**
		 * Element: div
		 * {DOMElement} DOM element for the control.
		 */
		div : Legato.Lang.Element,
		/**
		 * Element: type
		 * {<OpenLayers.Control.TYPE>} Type of the control.
		 */
		type : Legato.Lang['OpenLayers.Control.TYPE'],
		/**
		 * Element: allowSelection
		 * {Boolean} 
		 */
		allowSelection : Legato.Lang.Boolean,
		/**
		 * Element: displayClass
		 * {String}
		 */
		displayClass : Legato.Lang.String,
		/**
		 * Element: title
		 * {String}
		 */
		title : Legato.Lang.String
	}
});