/*
 * Legato is a configurable, lightweight web mapping client that can be
 * easily embedded into web pages and portals, CMS and individual web
 * applications. Legato is implemented in JavaScript and based on the
 * popular open source library OpenLayers.
 *
 * Copyright (C) 2010  disy Informationssysteme GmbH, http://www.disy.net
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

/**
 * Class: Legato.Control.Legend.Plugin.LayerZoomToVisibleScale
 */
Legato.Control.Legend.Plugin.LayerZoomToVisibleScale = OpenLayers.Class(
    Legato.Control.Legend.Plugin, {

      afterInitialized: function() {
        //do nothing
      },

      onclick: function(event)
      {
        var currentScale = this.map.getScale();
        if (Legato.Lang.ObjectUtils.isNull(currentScale)) {
          return;
        }
        var scaleToZoom = currentScale;
        if (currentScale > this.layer.minScale) {
          scaleToZoom = this.layer.minScale - 0.000001;
        } else if (currentScale < this.layer.maxScale) {
          scaleToZoom = this.layer.maxScale + 0.000001;
        }
        this.map.zoomToScale(scaleToZoom);
        if (Legato.Lang.ObjectUtils.exists(event)) {
          OpenLayers.Event.stop(event, true);
        }
      },

      afterSetup : function() {
        this.map.events.on( {
          'moveend' :this.update,
          scope :this
        });
        this.div.onclick = OpenLayers.Function.bindAsEventListener(this.onclick, this);
      },

      beforeDestroyed : function() {
        this.map.events.un( {
          'moveend' :this.update,
          scope :this
        });
        this.div.onclick = null;
      },

      update : function() {
        var currentScale = this.map.getScale();
        if (Legato.Lang.ObjectUtils.isNull(currentScale)) {
          this.setVisible(false);
          return;
        }
        if (currentScale > this.layer.minScale || currentScale < this.layer.maxScale) {
          this.setVisible(true);
          this.div.style.display = 'block';
        } else {
          this.setVisible(false);
        }
      },

      CLASS_NAME :'Legato.Control.Legend.Plugin.LayerZoomToVisibleScale'
    });

/**
 * Class: Legato.Control.Legend.Plugin.LayerZoomToVisibleScale.Factory Factory class wich is
 * able to create a <Legato.Control.Legend.Plugin.LayerZoomToVisibleScale> instance.
 */
Legato.Control.Legend.Plugin.LayerZoomToVisibleScale.Factory = OpenLayers.Class(
    Legato.Control.Legend.Plugin.Factory, {

      /**
       * Function: create Factory method for creating a
       * <Legato.Control.Legend.Plugin.LayerZoomToVisibleScale> instance.
       */
      create : function(layer) {
        return new Legato.Control.Legend.Plugin.LayerZoomToVisibleScale(layer,
            this.pluginOptions);
      },
      CLASS_NAME :'Legato.Control.Legend.Plugin.LayerZoomToVisibleScale.Factory'

    });

/**
 * Structure: lpp:LayerZoomToVisibleScale XML based config for
 * <Legato.Control.Legend.Plugin.LayerZoomToVisibleScale>.
 *
 * See Also: - <Legato.Control.Legend.Plugin> - <Legato.Beans.BeanFactory> -
 * <QName>
 *
 * A valid config example for a LayerZoomToVisibleScale Plugin would be:
 * (start code)
 * <llp:LayerZoomToVisibleScale />
 * (end)
 */
Legato.Control.Legend.Plugin.LayerZoomToVisibleScale.Bean = Legato.Control.Legend.Plugin.Bean
    .Extend('Legato.Control.Legend.Plugin.LayerZoomToVisibleScale.Factory',

    /**
     * Property: QName The qualified name for this control. Needed by XML config
     * to instantiate it.
     */
    Legato.Control.Legend.Plugin.QName('LayerZoomToVisibleScale'), {
      _constructor :Legato.Control.Legend.Plugin.LayerZoomToVisibleScale.Factory
    });