/*
 * Decompiled with CFR 0.152.
 */
package org.directwebremoting.util;

public class HitMonitor {
    private long zeroTimestamp = this.getCurrentTimestamp();
    private final long[] hitLog;

    public HitMonitor(int seconds) {
        this.hitLog = new long[seconds];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void recordHit() {
        long[] lArray = this.hitLog;
        synchronized (this.hitLog) {
            this.trimHitLog();
            this.hitLog[0] = this.hitLog[0] + 1L;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getHitsInLastPeriod() {
        long[] lArray = this.hitLog;
        synchronized (this.hitLog) {
            this.trimHitLog();
            int count = 0;
            for (int i = 0; i < this.hitLog.length; ++i) {
                count = (int)((long)count + this.hitLog[i]);
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return count;
        }
    }

    private void trimHitLog() {
        long now = this.getCurrentTimestamp();
        int secondsPassedSinceLastHit = (int)(now - this.zeroTimestamp);
        this.zeroTimestamp = now;
        if (secondsPassedSinceLastHit > 0) {
            for (int i = this.hitLog.length - 1; i >= 0; --i) {
                this.hitLog[i] = i >= secondsPassedSinceLastHit ? this.hitLog[i - secondsPassedSinceLastHit] : 0L;
            }
        }
    }

    private long getCurrentTimestamp() {
        return System.currentTimeMillis() / 1000L;
    }
}

