/*
 * Decompiled with CFR 0.152.
 */
package net.disy.legato.tools.jts;

import com.vividsolutions.jts.geom.MultiPoint;
import com.vividsolutions.jts.geom.Point;
import java.text.MessageFormat;
import net.disy.legato.tools.jts.AbstractGeometryConverter;
import net.disy.legato.tools.jts.PointConverter;
import org.directwebremoting.extend.MarshallException;

public class MultiPointConverter
extends AbstractGeometryConverter<MultiPoint, double[][]> {
    private final PointConverter converter = new PointConverter();

    @Override
    protected String getGeometryType() {
        return "MultiPoint";
    }

    @Override
    protected Class<double[][]> getCoordinatesType() {
        return double[][].class;
    }

    @Override
    protected double[][] createCoordinates(MultiPoint geometry) throws MarshallException {
        if (geometry == null) {
            return null;
        }
        if (geometry.isEmpty()) {
            return new double[0][0];
        }
        double[][] coordinates = new double[geometry.getNumGeometries()][];
        for (int index = 0; index < coordinates.length; ++index) {
            coordinates[index] = this.converter.createCoordinates((Point)geometry.getGeometryN(index));
        }
        return coordinates;
    }

    @Override
    protected MultiPoint createGeometry(double[][] coordinates) throws MarshallException {
        if (coordinates == null) {
            return null;
        }
        if (coordinates.length > 0) {
            Point[] geometries = new Point[coordinates.length];
            for (int index = 0; index < coordinates.length; ++index) {
                geometries[index] = this.converter.createGeometry(coordinates[index]);
            }
            return this.getGeometryFactory().createMultiPoint(geometries);
        }
        throw new MarshallException(MultiPoint.class, MessageFormat.format("Incorrect number of coordinate components [{0}].", coordinates.length));
    }
}

