/*
 * Decompiled with CFR 0.152.
 */
package net.disy.ogc.wpspd.v_1_0_0.sample;

import com.vividsolutions.jts.geom.Polygon;
import java.util.Arrays;
import java.util.List;
import javax.xml.bind.JAXBElement;
import net.disy.ogc.wps.v_1_0_0.annotation.InputParameter;
import net.disy.ogc.wps.v_1_0_0.annotation.OutputParameter;
import net.disy.ogc.wps.v_1_0_0.annotation.Process;
import net.disy.ogc.wps.v_1_0_0.annotation.ProcessMethod;
import net.disy.ogc.wpspd.v_1_0_0.Geometry;
import net.disy.ogc.wpspd.v_1_0_0.GeometryType;
import net.disy.ogc.wpspd.v_1_0_0.Group;
import net.disy.ogc.wpspd.v_1_0_0.GroupType;
import net.disy.ogc.wpspd.v_1_0_0.Marker;
import net.disy.ogc.wpspd.v_1_0_0.MarkerType;
import net.disy.ogc.wpspd.v_1_0_0.Message;
import net.disy.ogc.wpspd.v_1_0_0.MessageType;
import net.disy.ogc.wpspd.v_1_0_0.ObjectFactory;
import net.disy.ogc.wpspd.v_1_0_0.WpspdUtils;
import org.jvnet.ogc.gml.v_3_1_1.jts.JTSToGML311GeometryConverter;

@Process(id="sampleGroupOfGeometricMarkersWithMessagesProcess", title="Sample group of geometric markers process", description="Returns a group of geometric markers with messages")
public class SampleGroupOfGeometricMarkersWithMessagesAnnotatedObject {
    private final ObjectFactory wpspdObjectFactory = WpspdUtils.createObjectFactory();
    private final JTSToGML311GeometryConverter geometryConverter = new JTSToGML311GeometryConverter();

    @ProcessMethod
    @OutputParameter(id="markers", title="Markers", description="Resulting geometric markers")
    public Group execute(@InputParameter(id="firstGeometry", title="First geometry", description="First geometry") Polygon one, @InputParameter(id="secondGeometry", title="Second geometry", description="Second geometry") Polygon two, @InputParameter(id="thridGeometry", title="Third geometry", description="Third geometry", optional=true) Polygon three) {
        List<Polygon> polygons = Arrays.asList(one, two, three);
        GroupType groupType = this.wpspdObjectFactory.createGroupType();
        Group group = this.wpspdObjectFactory.createGroup(groupType);
        for (Polygon polygon : polygons) {
            if (polygon == null) continue;
            groupType.getPresentationDirective().add(this.createMarker(polygon));
        }
        return group;
    }

    private Marker createMarker(Polygon polygon) {
        MarkerType markerType = this.wpspdObjectFactory.createMarkerType();
        markerType.setGeometry(this.createGeometry(polygon));
        markerType.setMessage(this.createMessage(polygon));
        Marker marker = this.wpspdObjectFactory.createMarker(markerType);
        return marker;
    }

    private Geometry createGeometry(Polygon polygon) {
        JAXBElement geometryElement = this.geometryConverter.createElement((com.vividsolutions.jts.geom.Geometry)polygon);
        GeometryType geometryType = this.wpspdObjectFactory.createGeometryType();
        geometryType.setGeometry(geometryElement);
        Geometry geometry = this.wpspdObjectFactory.createGeometry(geometryType);
        return geometry;
    }

    private Message createMessage(Polygon polygon) {
        MessageType messageType = this.wpspdObjectFactory.createMessageType();
        messageType.setContent((Object)("Area:" + polygon.getArea()));
        Message message = this.wpspdObjectFactory.createMessage(messageType);
        return message;
    }
}

