/*
 * Decompiled with CFR 0.152.
 */
package net.disy.ogc.wps.v_1_0_0.sample;

import java.math.BigInteger;
import java.util.GregorianCalendar;
import java.util.Locale;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import net.disy.ogc.ows.v_1_1_0.OwsException;
import net.disy.ogc.wps.v_1_0_0.WpsProcess;
import net.disy.ogc.wps.v_1_0_0.util.WpsUtils;
import net.opengis.ows.v_1_1_0.AnyValue;
import net.opengis.ows.v_1_1_0.CodeType;
import net.opengis.wps.v_1_0_0.DataInputsType;
import net.opengis.wps.v_1_0_0.DataType;
import net.opengis.wps.v_1_0_0.ExecuteResponse;
import net.opengis.wps.v_1_0_0.InputDescriptionType;
import net.opengis.wps.v_1_0_0.InputType;
import net.opengis.wps.v_1_0_0.LiteralDataType;
import net.opengis.wps.v_1_0_0.LiteralInputType;
import net.opengis.wps.v_1_0_0.LiteralOutputType;
import net.opengis.wps.v_1_0_0.OutputDataType;
import net.opengis.wps.v_1_0_0.OutputDefinitionsType;
import net.opengis.wps.v_1_0_0.OutputDescriptionType;
import net.opengis.wps.v_1_0_0.ProcessDescriptionType;
import net.opengis.wps.v_1_0_0.ResponseFormType;
import net.opengis.wps.v_1_0_0.StatusType;

public class LiteralEchoWpsProcess
implements WpsProcess {
    @Override
    public ExecuteResponse execute(DataInputsType dataInputs, ResponseFormType responseForm, String language) throws OwsException {
        boolean lineage;
        ExecuteResponse executeResponse = new ExecuteResponse();
        executeResponse.setService("WPS");
        executeResponse.setVersion("1.0.0");
        executeResponse.setLang(Locale.ENGLISH.toString());
        executeResponse.setProcess(WpsUtils.createBriefDescription(this.getProcessDescription()));
        StatusType status = new StatusType();
        status.setProcessSucceeded("Ok.");
        try {
            status.setCreationTime(DatatypeFactory.newInstance().newXMLGregorianCalendar(new GregorianCalendar()));
        }
        catch (DatatypeConfigurationException ignored) {
            // empty catch block
        }
        executeResponse.setStatus(status);
        boolean bl = lineage = responseForm != null && responseForm.getResponseDocument() != null && responseForm.getResponseDocument().isLineage();
        if (lineage) {
            executeResponse.setDataInputs(dataInputs);
            if (!responseForm.getResponseDocument().getOutput().isEmpty()) {
                OutputDefinitionsType outputDefinitions = new OutputDefinitionsType();
                outputDefinitions.getOutput().addAll(responseForm.getResponseDocument().getOutput());
                executeResponse.setOutputDefinitions(outputDefinitions);
            }
        }
        ExecuteResponse.ProcessOutputs processOutputs = new ExecuteResponse.ProcessOutputs();
        executeResponse.setProcessOutputs(processOutputs);
        for (InputType input : dataInputs.getInput()) {
            OutputDataType output = new OutputDataType();
            output.setIdentifier(WpsUtils.createCodeType("echo"));
            output.setTitle(WpsUtils.createLanguageStringType("Echo process"));
            CodeType identifier = input.getIdentifier();
            if (identifier.getCodeSpace() == null && "echo".equals(identifier.getValue())) {
                DataType data = input.getData();
                LiteralDataType literalData = data.getLiteralData();
                String value = literalData.getValue();
                DataType outputData = new DataType();
                LiteralDataType literalOutputDataType = new LiteralDataType();
                outputData.setLiteralData(literalOutputDataType);
                literalOutputDataType.setValue(value);
                output.setData(outputData);
            }
            processOutputs.getOutput().add(output);
        }
        return executeResponse;
    }

    @Override
    public ProcessDescriptionType getProcessDescription() {
        ProcessDescriptionType processDescription = new ProcessDescriptionType();
        processDescription.setIdentifier(WpsUtils.createCodeType("echo"));
        processDescription.setTitle(WpsUtils.createLanguageStringType("Echo process"));
        processDescription.setAbstract(WpsUtils.createLanguageStringType("Echo process"));
        processDescription.setProcessVersion("1.0.0");
        processDescription.setStatusSupported(false);
        ProcessDescriptionType.DataInputs dataInputs = new ProcessDescriptionType.DataInputs();
        processDescription.setDataInputs(dataInputs);
        InputDescriptionType input = new InputDescriptionType();
        dataInputs.getInput().add(input);
        input.setIdentifier(WpsUtils.createCodeType("echo"));
        input.setAbstract(WpsUtils.createLanguageStringType("Echo input parameter"));
        input.setTitle(WpsUtils.createLanguageStringType("Echo input parameter"));
        input.setMinOccurs(BigInteger.valueOf(1L));
        input.setMaxOccurs(BigInteger.valueOf(1L));
        LiteralInputType literalInput = new LiteralInputType();
        input.setLiteralData(literalInput);
        literalInput.setAnyValue(new AnyValue());
        ProcessDescriptionType.ProcessOutputs processOutputs = new ProcessDescriptionType.ProcessOutputs();
        processDescription.setProcessOutputs(processOutputs);
        OutputDescriptionType output = new OutputDescriptionType();
        processOutputs.getOutput().add(output);
        output.setIdentifier(WpsUtils.createCodeType("echo"));
        output.setTitle(WpsUtils.createLanguageStringType("Echo output parameter"));
        output.setAbstract(WpsUtils.createLanguageStringType("Echo output parameter"));
        LiteralOutputType literalOutput = new LiteralOutputType();
        output.setLiteralOutput(literalOutput);
        return processDescription;
    }
}

