/*
 * Decompiled with CFR 0.152.
 */
package net.disy.ogc.wps.v_1_0_0.procedure;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.disy.ogc.wps.v_1_0_0.model.DataTypeTypeVisitor;
import net.disy.ogc.wps.v_1_0_0.model.Format;
import net.disy.ogc.wps.v_1_0_0.model.LiteralType;
import net.disy.ogc.wps.v_1_0_0.procedure.InputParameterDescription;
import net.disy.ogc.wps.v_1_0_0.procedure.WpsProcessContext;
import net.opengis.ows.v_1_1_0.CodeType;
import net.opengis.wps.v_1_0_0.DataType;
import net.opengis.wps.v_1_0_0.InputType;

public class InputArgumentBuilder {
    private final Map<String, List<InputType>> inputMap = new HashMap<String, List<InputType>>();
    private List<InputParameterDescription> inputParameters;
    private Set<String> parameterIds;
    private final WpsProcessContext context;

    public InputArgumentBuilder(WpsProcessContext context) {
        this.context = context;
    }

    public void setInputParameters(List<InputParameterDescription> inputParameters) {
        this.inputParameters = inputParameters;
        this.parameterIds = new HashSet<String>();
        for (InputParameterDescription inputParameter : inputParameters) {
            this.parameterIds.add(inputParameter.getId());
        }
    }

    public void addInput(InputType input) {
        CodeType identifier = input.getIdentifier();
        if (identifier.getCodeSpace() != null) {
            throw new IllegalArgumentException("CodeSpace must be null.");
        }
        String parameterId = identifier.getValue();
        if (!this.parameterIds.contains(parameterId)) {
            throw new IllegalArgumentException("Unexpected InputParameter with identifier '" + parameterId + "'");
        }
        this.getInputs(parameterId).add(input);
    }

    private List<InputType> getInputs(String parameterId) {
        if (this.inputMap.containsKey(parameterId)) {
            return this.inputMap.get(parameterId);
        }
        ArrayList<InputType> inputList = new ArrayList<InputType>();
        this.inputMap.put(parameterId, inputList);
        return inputList;
    }

    public Object[] getArguments() {
        Object[] arguments = new Object[this.inputParameters.size()];
        for (int i = 0; i < this.inputParameters.size(); ++i) {
            InputParameterDescription inputParameter = this.inputParameters.get(i);
            List<InputType> input = this.getInputs(inputParameter.getId());
            this.checkInputCount(inputParameter, input.size());
            arguments[i] = this.getInputArgument(input, inputParameter);
        }
        return arguments;
    }

    private void checkInputCount(InputParameterDescription inputParameter, int size) {
        if (!inputParameter.isOptional() && size == 0) {
            throw new IllegalArgumentException("inputParameter '" + inputParameter.getId() + "' is required.");
        }
    }

    private <S, D> Object getInputArgument(List<InputType> inputList, InputParameterDescription inputParameter) {
        Class<?> typeClass = inputParameter.getParameterClass();
        if (typeClass.isArray()) {
            Object array = Array.newInstance(typeClass.getComponentType(), inputList.size());
            for (int i = 0; i < inputList.size(); ++i) {
                Object value = this.getInputValue(typeClass.getComponentType(), inputParameter, inputList.get(i));
                Array.set(array, i, value);
            }
            return array;
        }
        if (inputList.isEmpty()) {
            return null;
        }
        if (inputList.size() != 1) {
            throw new IllegalArgumentException("Input parameter count mismatch.");
        }
        return this.getInputValue(typeClass, inputParameter, inputList.get(0));
    }

    private <S, D> Object getInputValue(Class<D> theClass, InputParameterDescription inputParameter, InputType inputData) {
        final net.disy.ogc.wps.v_1_0_0.model.DataType<?> dataType = this.context.getDataTypeHelper().getDataType(inputParameter, theClass);
        final DataType input = inputData.getData();
        class InputValueProvider
        implements DataTypeTypeVisitor {
            S unconvertedValue;

            InputValueProvider() {
            }

            @Override
            public void visitBBox() {
                this.unconvertedValue = input.getBoundingBoxData();
            }

            @Override
            public void visitComplex() {
                this.unconvertedValue = InputArgumentBuilder.this.getComplexInputValue(dataType, input);
            }

            @Override
            public void visitLiteral() {
                this.unconvertedValue = InputArgumentBuilder.this.getLiteralInputValue(dataType, input);
            }
        }
        InputValueProvider inputValueProvider = new InputValueProvider();
        dataType.getType().accept(inputValueProvider);
        return this.context.getConverterRegistry().convertTo(dataType.getTargetClass(), theClass, inputValueProvider.unconvertedValue);
    }

    private <S> S getLiteralInputValue(net.disy.ogc.wps.v_1_0_0.model.DataType<S> dataType, DataType input) {
        LiteralType<S> literalType = this.context.getLiteralTypeRegistry().getLiteralType(dataType);
        return literalType.valueOf(input.getLiteralData().getValue());
    }

    private <S> S getComplexInputValue(net.disy.ogc.wps.v_1_0_0.model.DataType<S> dataType, DataType input) {
        Format<S> format = this.context.getFormatRegistry().getDefaultFormat(dataType);
        return format.unmarshal(input.getComplexData().getContent());
    }
}

