/*
 * Decompiled with CFR 0.152.
 */
package net.disy.ogc.wps.v_1_0_0.procedure;

import java.math.BigInteger;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.disy.ogc.wps.v_1_0_0.model.CRS;
import net.disy.ogc.wps.v_1_0_0.model.DataType;
import net.disy.ogc.wps.v_1_0_0.model.DataTypeTypeVisitor;
import net.disy.ogc.wps.v_1_0_0.model.Format;
import net.disy.ogc.wps.v_1_0_0.model.FormatId;
import net.disy.ogc.wps.v_1_0_0.model.LiteralType;
import net.disy.ogc.wps.v_1_0_0.procedure.AbstractDataInputOutputBuilder;
import net.disy.ogc.wps.v_1_0_0.procedure.InputParameterDescription;
import net.disy.ogc.wps.v_1_0_0.procedure.WpsProcessContext;
import net.disy.ogc.wps.v_1_0_0.util.WpsUtils;
import net.opengis.ows.v_1_1_0.AllowedValues;
import net.opengis.ows.v_1_1_0.DomainMetadataType;
import net.opengis.ows.v_1_1_0.MetadataType;
import net.opengis.ows.v_1_1_0.ValueType;
import net.opengis.wps.v_1_0_0.CRSsType;
import net.opengis.wps.v_1_0_0.ComplexDataType;
import net.opengis.wps.v_1_0_0.InputDescriptionType;
import net.opengis.wps.v_1_0_0.LiteralInputType;
import net.opengis.wps.v_1_0_0.ProcessDescriptionType;
import net.opengis.wps.v_1_0_0.SupportedCRSsType;
import net.opengis.wps.v_1_0_0.SupportedComplexDataInputType;
import net.opengis.wps.v_1_0_0.SupportedComplexDataType;

public class DataInputBuilder
extends AbstractDataInputOutputBuilder {
    private final ProcessDescriptionType.DataInputs dataInputs;
    private final Set<String> ids = new HashSet<String>();

    public DataInputBuilder(WpsProcessContext context) {
        super(context);
        this.dataInputs = context.getWpsObjectFactory().createProcessDescriptionTypeDataInputs();
    }

    public void addParameter(InputParameterDescription parameter) {
        InputDescriptionType inputDescription = this.getInputDescription(parameter);
        this.handleInputDescriptionForParameterType(inputDescription, parameter);
        String id = inputDescription.getIdentifier().getValue();
        if (this.ids.contains(id)) {
            throw new IllegalStateException("Multiple declaration of inputParameter with identifier '" + id + "'");
        }
        this.ids.add(id);
        this.dataInputs.getInput().add(inputDescription);
    }

    private InputDescriptionType getInputDescription(InputParameterDescription parameter) {
        InputDescriptionType input = this.getContext().getWpsObjectFactory().createInputDescriptionType();
        input.setIdentifier(WpsUtils.createCodeType(parameter.getId()));
        input.setTitle(WpsUtils.createLanguageStringType(parameter.getTitle()));
        input.setAbstract(WpsUtils.createLanguageStringType(parameter.getAbstract()));
        List<MetadataType> metadata = parameter.getMetadata();
        if (!metadata.isEmpty()) {
            input.setMetadata(metadata);
        }
        return input;
    }

    private void handleInputDescriptionForParameterType(final InputDescriptionType inputDescription, final InputParameterDescription parameter) {
        inputDescription.setMinOccurs(parameter.isOptional() ? BigInteger.ZERO : BigInteger.ONE);
        if (parameter.getParameterClass().isArray()) {
            inputDescription.setMaxOccurs(BigInteger.valueOf(65535L));
        } else {
            inputDescription.setMaxOccurs(BigInteger.valueOf(1L));
        }
        final DataType<?> dataType = this.getContext().getDataTypeHelper().getDataType(parameter, parameter.getParameterClass());
        dataType.getType().accept(new DataTypeTypeVisitor(){

            @Override
            public void visitLiteral() {
                DataInputBuilder.this.addLiteralInput(parameter, inputDescription, dataType);
            }

            @Override
            public void visitComplex() {
                DataInputBuilder.this.addComplexInput(parameter, inputDescription, dataType);
            }

            @Override
            public void visitBBox() {
                DataInputBuilder.this.addBoundingBoxInput(parameter, inputDescription, dataType);
            }
        });
    }

    private void addLiteralInput(InputParameterDescription parameter, InputDescriptionType inputDescription, DataType<?> dataType) {
        List<Object> parameterAllowedValues;
        DomainMetadataType metadataType = this.getMetaDataType(dataType);
        LiteralInputType literalData = this.getContext().getWpsObjectFactory().createLiteralInputType();
        literalData.setDataType(metadataType);
        inputDescription.setLiteralData(literalData);
        Object defaultValue = parameter.getDefaultValue();
        LiteralType<?> literalType = this.getContext().getLiteralTypeRegistry().getLiteralType(dataType);
        if (defaultValue != null) {
            String value = literalType.toString(defaultValue);
            literalData.setDefaultValue(value);
        }
        if ((parameterAllowedValues = parameter.getAllowedValues()) != null && !parameterAllowedValues.isEmpty()) {
            AllowedValues allowedValues = new AllowedValues();
            for (Object parameterAllowedValue : parameterAllowedValues) {
                ValueType valueType = new ValueType();
                valueType.setValue(literalType.toString(parameterAllowedValue));
                allowedValues.getValueOrRange().add(valueType);
            }
            literalData.setAllowedValues(allowedValues);
        } else {
            literalData.setAnyValue(this.getContext().getOwsObjectFactory().createAnyValue());
        }
    }

    private void addComplexInput(InputParameterDescription parameter, InputDescriptionType inputDescription, DataType<?> dataType) {
        SupportedComplexDataInputType complexData = this.getContext().getWpsObjectFactory().createSupportedComplexDataInputType();
        inputDescription.setComplexData(complexData);
        this.addDataCombinations(dataType, (SupportedComplexDataType)complexData);
        Object defaultValue = parameter.getDefaultValue();
        if (defaultValue != null) {
            ComplexDataType value = this.getContext().getWpsObjectFactory().createComplexDataType();
            Format<?> format = this.getContext().getFormatRegistry().getDefaultFormat(dataType);
            FormatId formatId = format.getFormatId();
            value.setEncoding(formatId.getEncoding());
            value.setMimeType(formatId.getMimeType());
            value.setSchema(formatId.getSchemaDesignator());
            value.setContent(format.marshal(defaultValue));
            complexData.setDefaultValue(value);
        }
    }

    private void addBoundingBoxInput(InputParameterDescription parameter, InputDescriptionType inputDescription, DataType<?> dataType) {
        SupportedCRSsType supportedCRSsType = this.getContext().getWpsObjectFactory().createSupportedCRSsType();
        inputDescription.setBoundingBoxData(supportedCRSsType);
        SupportedCRSsType.Default defaultCRS = this.getContext().getWpsObjectFactory().createSupportedCRSsTypeDefault();
        supportedCRSsType.setDefault(defaultCRS);
        defaultCRS.setCRS(this.getContext().getCRSRegistry().getDefaultCRS().getName());
        CRSsType supportedCRSs = this.getContext().getWpsObjectFactory().createCRSsType();
        for (CRS supportedCRS : this.getContext().getCRSRegistry().getSupportedCRSs()) {
            supportedCRSs.getCRS().add(supportedCRS.getName());
        }
        supportedCRSsType.setSupported(supportedCRSs);
    }

    public ProcessDescriptionType.DataInputs getDataInputs() {
        return this.dataInputs;
    }
}

