/*
 * Decompiled with CFR 0.152.
 */
package net.disy.ogc.wps.v_1_0_0.annotation;

import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import net.disy.ogc.ows.v_1_1_0.NoApplicableCodeException;
import net.disy.ogc.ows.v_1_1_0.OwsException;
import net.disy.ogc.wps.v_1_0_0.annotation.AllowedValueRestriction;
import net.disy.ogc.wps.v_1_0_0.annotation.AnnotationInputParameterDescription;
import net.disy.ogc.wps.v_1_0_0.annotation.AnnotationOutputParameterDescription;
import net.disy.ogc.wps.v_1_0_0.annotation.DefaultValue;
import net.disy.ogc.wps.v_1_0_0.annotation.DefaultValueFactory;
import net.disy.ogc.wps.v_1_0_0.annotation.InputParameter;
import net.disy.ogc.wps.v_1_0_0.annotation.MethodBasedValueEnumerator;
import net.disy.ogc.wps.v_1_0_0.annotation.OutputParameter;
import net.disy.ogc.wps.v_1_0_0.annotation.Process;
import net.disy.ogc.wps.v_1_0_0.annotation.ProcessMethod;
import net.disy.ogc.wps.v_1_0_0.annotation.ValueEnumerator;
import net.disy.ogc.wps.v_1_0_0.procedure.InputParameterDescription;
import net.disy.ogc.wps.v_1_0_0.procedure.OutputParameterDescription;
import net.disy.ogc.wps.v_1_0_0.procedure.WpsProcedure;
import net.disy.ogc.wps.v_1_0_0.util.WpsProcessUtilities;
import net.opengis.ows.v_1_1_0.MetadataType;
import org.apache.commons.collections15.CollectionUtils;
import org.apache.commons.collections15.Predicate;
import org.apache.commons.lang.Validate;

public class AnnotationWpsProcedure
implements WpsProcedure {
    private final Object annotatedObject;
    private final Process process;
    private final Method processMethod;
    private final List<InputParameterDescription> inputParameters;
    private final List<OutputParameterDescription> outputParameters;

    public AnnotationWpsProcedure(Object annotatedObject) {
        this.annotatedObject = annotatedObject;
        Process process = annotatedObject.getClass().getAnnotation(Process.class);
        if (process == null) {
            throw new IllegalArgumentException(MessageFormat.format("Class must be annotated with {0} annotation.", Process.class.getName()));
        }
        this.process = process;
        this.processMethod = WpsProcessUtilities.getSingleRequired(annotatedObject.getClass().getMethods(), new Predicate<Method>(){

            public boolean evaluate(Method object) {
                return object.isAnnotationPresent(ProcessMethod.class);
            }
        }, new IllegalArgumentException("Exactly one method must be annotated with " + ProcessMethod.class.getName()));
        this.inputParameters = Collections.unmodifiableList(this.createInputParametersDescriptions(annotatedObject));
        this.outputParameters = Collections.unmodifiableList(this.createOutputParameterDescriptions());
    }

    private List<OutputParameterDescription> createOutputParameterDescriptions() {
        ArrayList<OutputParameterDescription> outputParameters = new ArrayList<OutputParameterDescription>();
        OutputParameter outputParameter = this.processMethod.getAnnotation(OutputParameter.class);
        if (outputParameter != null) {
            outputParameters.add(new AnnotationOutputParameterDescription(outputParameter, this.processMethod.getReturnType()));
        }
        return outputParameters;
    }

    private List<InputParameterDescription> createInputParametersDescriptions(Object annotatedObject) {
        ArrayList<InputParameterDescription> inputParameters = new ArrayList<InputParameterDescription>();
        Class<?>[] parameterTypes = this.processMethod.getParameterTypes();
        Annotation[][] parameterAnnotations = this.processMethod.getParameterAnnotations();
        for (int i = 0; i < parameterTypes.length; ++i) {
            InputParameter inputParameter = this.getInputParameter(parameterAnnotations[i]);
            DefaultValue defaultValueAnnotation = AnnotationWpsProcedure.findNestedAnnotation(parameterAnnotations[i], DefaultValue.class);
            Object defaultValue = defaultValueAnnotation != null ? this.createDefaultValue(defaultValueAnnotation) : null;
            AllowedValueRestriction allowedValueRestriction = AnnotationWpsProcedure.findAnnotation(parameterAnnotations[i], AllowedValueRestriction.class);
            ValueEnumerator allowedValuesEnumerator = allowedValueRestriction != null ? AnnotationWpsProcedure.findEnumerator(annotatedObject, allowedValueRestriction.enumeratorMethod()) : null;
            inputParameters.add(new AnnotationInputParameterDescription(parameterTypes[i], inputParameter, defaultValue, allowedValuesEnumerator));
        }
        return inputParameters;
    }

    private Object createDefaultValue(Annotation defaultValueAnnotation) {
        Validate.notNull((Object)defaultValueAnnotation);
        try {
            Class<DefaultValueFactory<?, ?>> defaultValueFactoryClass = defaultValueAnnotation.annotationType().getAnnotation(DefaultValue.class).createdBy();
            DefaultValueFactory<?, ?> defaultValueFactory = defaultValueFactoryClass.newInstance();
            return defaultValueFactory.createDefaultValue(defaultValueAnnotation);
        }
        catch (Exception ex) {
            throw new IllegalArgumentException("Could not create the default value instance.", ex);
        }
    }

    public static ValueEnumerator findEnumerator(Object o, final String method) {
        Validate.notNull((Object)o);
        Validate.notEmpty((String)method);
        Collection enumeratorMethods = CollectionUtils.select(Arrays.asList(o.getClass().getMethods()), (Predicate)new Predicate<Method>(){

            public boolean evaluate(Method m) {
                return m.getName().equals(method);
            }
        });
        if (enumeratorMethods.size() > 1) {
            throw new IllegalArgumentException("Found more than 1 enumerator method on object of type '" + o.getClass() + "' for parameter with id '" + method + "'");
        }
        if (enumeratorMethods.isEmpty()) {
            return null;
        }
        return new MethodBasedValueEnumerator(o, (Method)enumeratorMethods.iterator().next());
    }

    private InputParameter getInputParameter(Annotation[] parameterAnnotations) {
        InputParameter inputParameter = (InputParameter)WpsProcessUtilities.getSingleRequired(parameterAnnotations, new Predicate<Annotation>(){

            public boolean evaluate(Annotation value) {
                return value instanceof InputParameter;
            }
        }, new IllegalStateException("Each parameter must be annotated with " + InputParameter.class.getName()));
        return inputParameter;
    }

    private static <T extends Annotation> T findNestedAnnotation(Annotation[] parameterAnnotations, final Class<T> nestedAnnotationClass) {
        return (T)((Annotation)CollectionUtils.find(Arrays.asList(parameterAnnotations), (Predicate)new Predicate<Annotation>(){

            public boolean evaluate(Annotation value) {
                return value.annotationType().isAnnotationPresent(nestedAnnotationClass);
            }
        }));
    }

    private static <T extends Annotation> T findAnnotation(Annotation[] annotations, final Class<T> annotationClass) {
        return (T)((Annotation)CollectionUtils.find(Arrays.asList(annotations), (Predicate)new Predicate<Annotation>(){

            public boolean evaluate(Annotation value) {
                return value.annotationType().equals(annotationClass);
            }
        }));
    }

    @Override
    public String getId() {
        return this.getProcess().id();
    }

    @Override
    public String getTitle() {
        return this.getProcess().title();
    }

    @Override
    public String getAbstract() {
        return this.getProcess().description();
    }

    @Override
    public List<MetadataType> getMetadata() {
        return WpsProcessUtilities.getMetadata(this.getProcess().metadata());
    }

    private Process getProcess() {
        return this.process;
    }

    @Override
    public List<InputParameterDescription> getInputParameters() {
        return this.inputParameters;
    }

    @Override
    public List<OutputParameterDescription> getOutputParameters() {
        return this.outputParameters;
    }

    @Override
    public Object execute(Object[] arguments) throws OwsException {
        try {
            return this.processMethod.invoke(this.annotatedObject, arguments);
        }
        catch (InvocationTargetException e) {
            if (e.getCause() instanceof OwsException) {
                throw (OwsException)e.getCause();
            }
            throw new NoApplicableCodeException("Service threw exception", e.getCause());
        }
        catch (IllegalAccessException e) {
            throw new NoApplicableCodeException("Service not accessible", e);
        }
    }
}

