/*
 * Decompiled with CFR 0.152.
 */
package net.disy.legato.tools.servlet;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.LinkedList;
import java.util.List;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.IOUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.DefaultHttpClient;

public class ProxyServlet
extends HttpServlet {
    private static final long serialVersionUID = 1L;
    private final List<String> allowedUrls = new LinkedList<String>();

    public void init() throws ServletException {
        String allowedUrlsParameter = this.getServletConfig().getInitParameter("allowedUrls");
        if (allowedUrlsParameter != null) {
            String[] urls;
            for (String url : urls = allowedUrlsParameter.split(",")) {
                String trimmedUrl = url.trim();
                if (!this.isValidUrl(trimmedUrl)) continue;
                this.allowedUrls.add(trimmedUrl);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String url = req.getParameter("url");
        if (!this.isAllowed(url)) {
            resp.setStatus(403);
            return;
        }
        DefaultHttpClient client = new DefaultHttpClient();
        HttpGet method = new HttpGet(url);
        try {
            HttpResponse httpResponse = client.execute((HttpUriRequest)method);
            int statusCode = httpResponse.getStatusLine().getStatusCode();
            if (statusCode != -1) {
                HttpEntity entity = httpResponse.getEntity();
                InputStream contentStream = entity.getContent();
                IOUtils.copy((InputStream)contentStream, (OutputStream)resp.getOutputStream());
            }
        }
        finally {
            method.releaseConnection();
        }
    }

    private boolean isValidUrl(String urlString) {
        try {
            URI uri = new URI(urlString);
            return uri.getHost() != null && !"".equals(uri.getHost());
        }
        catch (URISyntaxException e) {
            return false;
        }
    }

    private boolean isAllowed(String urlString) {
        try {
            URI uri = new URI(urlString);
            String startUrl = uri.normalize().toString();
            for (String allowedPrefix : this.allowedUrls) {
                if (!startUrl.startsWith(allowedPrefix)) continue;
                return true;
            }
            return false;
        }
        catch (URISyntaxException e) {
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        block18: {
            String url = req.getParameter("url");
            if (!this.isAllowed(url)) {
                resp.setStatus(403);
                return;
            }
            DefaultHttpClient client = new DefaultHttpClient();
            HttpPost method = new HttpPost(url);
            try {
                HttpResponse httpResponse = client.execute((HttpUriRequest)method);
                int statusCode = httpResponse.getStatusLine().getStatusCode();
                if (statusCode == -1) break block18;
                HttpEntity entity = httpResponse.getEntity();
                InputStream is = null;
                ServletOutputStream os = null;
                try {
                    is = entity.getContent();
                    try {
                        os = resp.getOutputStream();
                        IOUtils.copy((InputStream)is, (OutputStream)os);
                    }
                    finally {
                        if (os != null) {
                            try {
                                os.flush();
                            }
                            catch (IOException ignored) {}
                        }
                    }
                }
                catch (IOException ioex) {
                    String message = ioex.getMessage();
                    if (!"chunked stream ended unexpectedly".equals(message)) {
                        throw ioex;
                    }
                }
                finally {
                    IOUtils.closeQuietly((InputStream)is);
                }
            }
            finally {
                method.releaseConnection();
            }
        }
    }
}

