/*
 * Decompiled with CFR 0.152.
 */
package net.disy.legato.tools.jts;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.Point;
import java.text.MessageFormat;
import net.disy.legato.tools.jts.AbstractGeometryConverter;
import net.disy.legato.tools.jts.PointConverter;
import org.directwebremoting.extend.MarshallException;

public class LineStringConverter
extends AbstractGeometryConverter<LineString, double[][]> {
    private PointConverter pointConverter = new PointConverter();

    @Override
    protected String getGeometryType() {
        return "LineString";
    }

    @Override
    protected Class<double[][]> getCoordinatesType() {
        return double[][].class;
    }

    @Override
    public double[][] createCoordinates(LineString lineString) throws MarshallException {
        if (lineString == null) {
            return null;
        }
        if (lineString.isEmpty()) {
            return new double[0][0];
        }
        int numberOfPoints = lineString.getNumPoints();
        double[][] coordinates = new double[numberOfPoints][];
        for (int index = 0; index < numberOfPoints; ++index) {
            coordinates[index] = this.pointConverter.createCoordinates(lineString.getPointN(index));
        }
        return coordinates;
    }

    @Override
    public LineString createGeometry(double[][] coordinates) throws MarshallException {
        if (coordinates == null) {
            return null;
        }
        if (coordinates.length >= 2) {
            Coordinate[] coordinateArray = new Coordinate[coordinates.length];
            for (int index = 0; index < coordinates.length; ++index) {
                coordinateArray[index] = this.pointConverter.createGeometry(coordinates[index]).getCoordinate();
            }
            return this.getGeometryFactory().createLineString(coordinateArray);
        }
        throw new MarshallException(Point.class, MessageFormat.format("Incorrect number of coordinate components [{0}].", coordinates.length));
    }
}

