/*
 * Legato is a configurable, lightweight web mapping client that can be
 * easily embedded into web pages and portals, CMS and individual web
 * applications. Legato is implemented in JavaScript and based on the
 * popular open source library OpenLayers.
 *
 * Copyright (C) 2010  disy Informationssysteme GmbH, http://www.disy.net
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

WPS.Result.Group = OpenLayers.Class(WPS.Result, {
  results : null,
  factory : null,

  initialize : function(id, results, options) {
    WPS.Result.prototype.initialize.apply(this, [ id, options ]);
    // TODO must be string or element
    Legato.Util.Ensure.ensureExists(results, 'results should be defined');
    this.results = results;
  },

  execute : function(executionContext) {
    // TODO move to the factory
    for ( var index = 0; index < this.results.length; index++) {
      var result = this.results[index];
      result.execute(executionContext);
    }
  },

  createContent : function() {
    throw new Legato.Lang.Exception('The method createContent is not supported by the class' + this.CLASS_NAME);
  },

  destroy : function() {
    this.items = null;
    WPS.Result.prototype.destroy.apply(this, arguments);
  },

  CLASS_NAME : 'WPS.Result.Group'
});

WPS.Result.Group.ComplexFactory = OpenLayers.Class(
    WPS.Result.ComplexFactory, {

      schema : 'http://schemas.disy.net/wps-pd/1.0.0/wps-pd.xsd#Group',

      name : new Legato.XML.QName('http://www.disy.net/pd', 'Group', 'pd'),

      factory : null,

      initialize : function(map, factory) {
        Legato.Util.Ensure.ensureExists(map, 'map should be defined');
        Legato.Util.Ensure.ensureExists(factory, 'factory should be defined');
        this.map = map;
        this.factory = factory;
      },

      createResult : function(id, outputData, options) {

        var complexData = outputData.data.complexData;
        var value = complexData.content[0].value;
        var items;
        if (Legato.Lang.ObjectUtils.isArray(value.presentationDirective)) {
          items = value.presentationDirective;
        } else {
          items = [];
        }
        var results = [];
        for ( var index = 0; index < items.length; index++) {
          var item = items[index];
          var itemOutputData = {
            data : {
              complexData : {
                schema : 'http://schemas.disy.net/wps-pd/1.0.0/wps-pd.xsd#'
                    + item.name.localPart,
                mimeType : 'text/xml',
                encoding : 'utf-8',
                content : [ item ]

              }
            }
          };
          results.push(this.factory.createSingleNormalResult(itemOutputData,
              null, null));
        }

        return new WPS.Result.Group(id, results, options);
      },
      CLASS_NAME : 'WPS.Result.Group.ComplexFactory'
    });