/*
 * Legato is a configurable, lightweight web mapping client that can be
 * easily embedded into web pages and portals, CMS and individual web
 * applications. Legato is implemented in JavaScript and based on the
 * popular open source library OpenLayers.
 *
 * Copyright (C) 2010  disy Informationssysteme GmbH, http://www.disy.net
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

/**
 * @author $Author: valikov $
 * @version $Revision: 91043 $
 * @requires Legato.js
 */

/**
 * Stuff to make headless testing possible
 */
Legato.Test.Headless = {};

/*
 * Please consider that this is some sort of a hack. It should been executed
 * automatically using JSUnit but till then we're doing it by hand.
 */
Legato.Test.Headless.run = function(testFunctionNames) {
  if (typeof setUpPage !== 'undefined') {
    logger.info("Running setUpPage");
    setUpPage();
  }
  for ( var i = 0; i < testFunctionNames.length; ++i) {
    logger.info('Run Test: ' + testFunctionNames[i] + '()');
    if (typeof setUp == 'function') {
      logger.info('setUp Phase');
      setUp();
    }

    eval(testFunctionNames[i] + '()');

    if (typeof tearDown == 'function') {
      logger.info('tearDown Phase');
      tearDown();
    }
    logger.info('Done: ' + testFunctionNames[i] + '()');
  }
};

Legato.Util.assertArrayValues = function(array1, array2) {
  assertTrue(Legato.Lang.ObjectUtils.isArray(array1));
  assertTrue(Legato.Lang.ObjectUtils.isArray(array2));
  assertTrue(Legato.Lang.ObjectUtils.exists(array1.length));
  assertTrue(Legato.Lang.ObjectUtils.exists(array2.length));

  var i = 0;

  for (i = 0; i < array1.length; i++) {
    logger.info('1: ' + array1[i]);
  }
  for (i = 0; i < array2.length; i++) {
    logger.info('2: ' + array2[i]);
  }

  assertEquals(array1.length, array2.length);

  for (i = 0; i < array1.length; i++) {
    assertEquals(array1[i], array2[i]);
  }
};

JsUnitException.prototype.toString = function() {
  var result = '';
  if (this.comment) {
    result += this.comment + ': ';
  }
  result += this.jsUnitMessage;
  if (this.stackTrace) {
    result += '[' + this.stackTrace + ']';
  }
  return result;
};

function error(errorMessage) {
  throw new JsUnitException(null, errorMessage);
}

function exposeTestFunctionNames() {
  var testFunctionNames = [];
  /*jslint forin:true*/
  for ( var name in this) {
    // if (this.hasOwnProperty(name)) {
    var target = this[name];
    if ((name.substring(0, 4) == 'test') && (typeof target == 'function')) {
      testFunctionNames.push(name);
      if (!this.hasOwnProperty(name)) {
        throw new Error('gotcha');
      }
      // }
    }
  }
  return testFunctionNames;
}