/*
 * Legato is a configurable, lightweight web mapping client that can be
 * easily embedded into web pages and portals, CMS and individual web
 * applications. Legato is implemented in JavaScript and based on the
 * popular open source library OpenLayers.
 *
 * Copyright (C) 2010  disy Informationssysteme GmbH, http://www.disy.net
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

// Hack
OpenLayers.Layer.GML.prototype.requestSuccess = function(request) {
	var doc = request.responseXML;

	if (!doc || !doc.documentElement) {
		doc = request.responseText;
	}

	var options = {};

	OpenLayers.Util.extend(options, this.formatOptions);
	if (this.map && !this.projection.equals(this.map.getProjectionObject())) {
		options.externalProjection = this.projection;
		options.internalProjection = this.map.getProjectionObject();
	}

	var gml;

	if (Legato.Lang.ObjectUtils.exists(this.format)) {
		if (Legato.Lang.ObjectUtils.isFunction(this.format)) {
			gml = new this.format(options);
		} else {
			gml = this.format;
		}
	} else {
		gml = new OpenLayers.Format.GML(options);
	}
	this.addFeatures(gml.read(doc));
	this.events.triggerEvent("loadend");
};

/**
 * Component: oll:GML
 *
 * Creates a vector layer by parsing a GML resource.
 * 
 * Inherits from:
 * - {<oll:Vector>}
 * 
 * See also:
 * - <oll> namespace
 * - {<OpenLayers.Layer.Vector>}
 */
OpenLayers.Layer.GML.Bean = OpenLayers.Layer.Vector.Bean.Extend(
		'OpenLayers.Layer.GML',
		//
		Legato.OpenLayers.Layer.QName('GML'),
		//
		{
			_constructor : OpenLayers.Layer.GML,
			constructorArguments : {
				/**
				 * Element: name
				 * {String}
				 */
				name : Legato.Lang.String,
				/**
				 * Element: url
				 * {String}
				 */
				url : Legato.Lang.String
			},
			constructorOrder : [ 'name', 'url' ],
			options : {
				/**
				 * Element: format
				 * {<lf:Format>} The format you want the data to be parsed with.
				 */
				format : Legato.Beans.Object,
				/**
				 * Element: formatOptions
				 * {Object} Hash of options which should be passed to the format when it is created.
				 */
				formatOptions : Legato.Beans.Object
			}
		});

/**
 * Layer type: OGC:GML
 * 
 * See also:
 * - {<oll:GML>}
 * - {<OpenLayers.Layer.GML>}
 * 
 * WMC example:
 * (start code)
 * <Layer hidden="0" queryable="0">
 *   <Server service="OGC:GML" version="3.1.1">
 *     <OnlineResource xlink:href="gml.xml" xlink:type="simple" />
 *   </Server>
 *   <Name>GML</Name>
 *   <Title>GML Layer</Title>
 * </Layer>
 * (end)
 */
OpenLayers.Layer.GML.LayerFactory = Legato.Lang.Class(
//
Legato.Format.ExtendedWMC.LayerFactory,
//
{
	layerType : OpenLayers.Layer.GML.Bean
});

Legato.Format.ExtendedWMC.registerDefaultLayerFactory('OGC:GML',
		new OpenLayers.Layer.GML.LayerFactory());