/*
 * Legato is a configurable, lightweight web mapping client that can be
 * easily embedded into web pages and portals, CMS and individual web
 * applications. Legato is implemented in JavaScript and based on the
 * popular open source library OpenLayers.
 *
 * Copyright (C) 2010  disy Informationssysteme GmbH, http://www.disy.net
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

Legato.Layer.Predicate.LayerWithAttribute = OpenLayers.Class({
  name : null,
  value : null,
  predicate : null,
  initialize : function(options) {
    Legato.Util.Ensure.ensureString(options.name, 'Attribute name must be a string.');
    this.name = options.name;
    if (Legato.Lang.ObjectUtils.isObject(options.predicate)) {
      Legato.Util.Ensure.ensureFunction(options.predicate.evaluate, 'Predicate must define the [evaluate] function.');
      this.predicate = options.predicate;
    } else if (Legato.Lang.ObjectUtils.isString(options.value)) {
      this.predicate = new Legato.Predicate.Equals(options.value);
    } else {
      this.predicate = null;
    }
  },
  evaluate : function(layer) {
    if (Legato.Lang.ObjectUtils.isString(this.name)) {
      var attributes = layer.attributes;
      if (Legato.Lang.ObjectUtils.isObject(attributes)) {
        if (Legato.Lang.ObjectUtils.exists(this.predicate)) {
          return Legato.Lang.ObjectUtils.exists(attributes[this.name]) && this.predicate.evaluate(attributes[this.name]);
        } else {
          return Legato.Lang.ObjectUtils.exists(attributes[this.name]);
        }
      } else {
        return false;
      }

    } else {
      return true;
    }
  },
  CLASS_NAME : 'Legato.Layer.Predicate.LayerWithAttribute'
});

Legato.Layer.Predicate.LayerWithAttribute.Bean = Legato.Layer.Predicate.Bean.Extend('Legato.Layer.Predicate.LayerWithAttribute',
//
Legato.Layer.Predicate.QName('LayerWithAttribute'),
//
{
  _constructor : Legato.Layer.Predicate.LayerWithAttribute,
  options : {
    name : Legato.Lang.String,
    value : Legato.Lang.String,
    predicate : Legato.Beans.Object
  }
});
