/*
 * Legato is a configurable, lightweight web mapping client that can be
 * easily embedded into web pages and portals, CMS and individual web
 * applications. Legato is implemented in JavaScript and based on the
 * popular open source library OpenLayers.
 *
 * Copyright (C) 2010  disy Informationssysteme GmbH, http://www.disy.net
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

/*
 * @author $Author: valikov $
 * @version $Rev: 70574 $
 */

/*
 * Class: Legato.Graph.Vertex
 * 
 * Implements a vertex of the directed graph.
 */
Legato.Graph.Vertex = Legato.Lang.Class( {
  /*
   * Property: name
   * 
   * {String} Name of the vertex.
   */
  name :null,
  /*
   * Property: incoming
   *
   * {<Legato.Util.HashSet>} Set of incoming edges.
   */
  incoming :null,
  /*
   * Property: outgoing
   * 
   * {<Legato.Util.HashSet>} Set of outgoing edges.
   */
  outgoing :null,
  /*
   * Constructor: initialize
   * 
   * Constructs the vertex.
   * 
   * Parameters:
   * 
   * name - {String} name of the vertex.
   */
  initialize : function(name) {
    Legato.Util.Ensure.ensureString(name);
    this.name = name;
    this.incoming = new Legato.Util.HashSet();
    this.outgoing = new Legato.Util.HashSet();
  },
  /*
   * Function: hasIncomingEdges
   * 
   * Returns:
   * 
   * {Boolean} true if vertex has incoming edges, false if not.
   */
  hasIncomingEdges : function() {
    return !this.incoming.isEmpty();
  },
  /*
   * Creates a clone of this vertex.
   * 
   * Returns:
   * 
   * {<Legato.Graph.Vertex>} Clone of this vertex.
   */
  clone : function() {
    var vertex = new Legato.Graph.Vertex(this.name);
    vertex.incoming.addAll(this.incoming);
    vertex.outgoing.addAll(this.outgoing);
    return vertex;
  }
});