/*
 * Legato is a configurable, lightweight web mapping client that can be
 * easily embedded into web pages and portals, CMS and individual web
 * applications. Legato is implemented in JavaScript and based on the
 * popular open source library OpenLayers.
 *
 * Copyright (C) 2010  disy Informationssysteme GmbH, http://www.disy.net
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

/**
 * Component: oll:WMS
 * 
 * Inherits from:
 * - {<oll:Grid>}
 * 
 * See also:
 * - <oll> namespace
 * - {<OpenLayers.Layer.WMS}}
 * - <OGC:WMS> layer type
 */
OpenLayers.Layer.WMS.Bean = OpenLayers.Layer.Grid.Bean
		.Extend('OpenLayers.Layer.WMS',
		//
		Legato.OpenLayers.Layer.QName('WMS'),
				//
				{
					factoryFunction : function(name, url, params, options) {
						if (!Legato.Lang.ObjectUtils.exists(params)) {
							params = {};
						}
						if (!Legato.Lang.ObjectUtils.exists(options)) {
							options = {};
						}
						if (!Legato.Lang.ObjectUtils.exists(params.LAYERS)) {
							params.LAYERS = name;
						}
						if (!Legato.Lang.ObjectUtils.exists(params.TRANSPARENT)
								&& Legato.Lang.ObjectUtils
										.exists(options.transparent)) {
							params.TRANSPARENT = options.transparent ? 'TRUE'
									: 'FALSE';
							delete options.transparent;
						}
						if (!Legato.Lang.ObjectUtils.exists(params.EXCEPTIONS)
								&& Legato.Lang.ObjectUtils
										.exists(options.exceptions)) {
							params.EXCEPTIONS = options.exceptions;
							delete options.exceptions;
						}
						if (!Legato.Lang.ObjectUtils.exists(params.FORMAT)
								&& Legato.Lang.ObjectUtils
										.exists(options.format)) {
							params.FORMAT = options.format;
							delete options.format;
						}

						return new OpenLayers.Layer.WMS(name, url, params,
								options);
					},
					constructorArguments : {
						/**
						 * Element: name
						 * {String}
						 */
						name : Legato.Lang.String,
						/**
						 * Element: url
						 * {String}
						 */
						url : Legato.Lang.String,
						/**
						 * Element: params
						 * {String {}}
						 */
						params : Legato.Lang['String{}']
					},
					constructorOrder : [ 'name', 'url', 'params' ],
					options : {
						/**
						 * Element: reproject
						 * {Boolean}
						 */
						reproject : Legato.Lang.Boolean,
						/**
						 * Element: encodeBBOX
						 * {Boolean}
						 */
						encodeBBOX : Legato.Lang.Boolean,
						/**
						 * Element: transparent
						 * {Boolean}
						 */
						transparent : Legato.Lang.Boolean,
						/**
						 * Element: exceptions
						 * {String}
						 */
						exceptions : Legato.Lang.String,
						/**
						 * Element: format
						 * {String}
						 */
						format : Legato.Lang.String,
						/**
						 * Element: style
						 * {String}
						 */
						style : Legato.Lang.String
					},
					afterInstancePopulated : function(layer) {
						if (!Legato.Lang.ObjectUtils.isObject(layer.params)) {
							layer.params = {};
						}
						if (!Legato.Lang.ObjectUtils
								.exists(layer.params.LAYERS)) {
							layer.params.LAYERS = layer.name;
						}
					}
				});

/**
 * Layer type: OGC:WMS
 * 
 * See also:
 * - {<oll:WMS>}
 * - {<OpenLayers.Layer.WMS>}
 * 
 * WMC example:
 * (start code)
 * <Layer queryable="0" hidden="0">                                                                       
 *   <Server service="OGC:WMS" version="1.1.1" title="OGC:WMS">                                           
 *     <OnlineResource xlink:type="simple" xlink:href="http://maps.opengeo.org/geowebcache/service/wms" />
 *   </Server>                                                                                            
 *   <Name>bluemarble</Name>                                                                              
 *   <Title>Blue Marble</Title>                                                                           
 *   <FormatList>                                                                                         
 *     <Format current="0">image/png</Format>                                                             
 *   </FormatList>                                                                                        
 * </Layer>                                                                                               
 * (end)
 */
OpenLayers.Layer.WMS.LayerFactory = Legato.Lang.Class(
//
Legato.Format.ExtendedWMC.LayerFactory,
//
{
	layerType : OpenLayers.Layer.WMS.Bean
});

Legato.Format.ExtendedWMC.registerDefaultLayerFactory('OGC:WMS',
		new OpenLayers.Layer.WMS.LayerFactory());