/*
 * Legato is a configurable, lightweight web mapping client that can be
 * easily embedded into web pages and portals, CMS and individual web
 * applications. Legato is implemented in JavaScript and based on the
 * popular open source library OpenLayers.
 *
 * Copyright (C) 2010  disy Informationssysteme GmbH, http://www.disy.net
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

Legato.Control.SetMapSize = OpenLayers.Class(OpenLayers.Control, {

  type : OpenLayers.Control.TYPE_BUTTON,
  selectElement : null,
  mapSizes : null,
  mapSizeOptionElements : null,
  customMapSizeName : "Custom",
  maintainExtent : false,
  zoomToClosest : true,
  initialize : function(options) {
    OpenLayers.Control.prototype.initialize.apply(this, [ options ]);
    if (!Legato.Lang.ObjectUtils.exists(this.mapSizes)) {
      this.mapSizes = {};
    }
    this.mapSizeOptionElements = {};
  },
  draw : function() {
    var div = OpenLayers.Control.prototype.draw.apply(this, arguments);
    if (!Legato.Lang.ObjectUtils.exists(this.selectElement)) {
      this.selectElement = document.createElement('select');
      this.selectElement.id = this.id + "_SelectElement";
      this.selectElement.name = this.id + "_SelectElement";
      this.selectElement.title = this.title;

      for ( var mapSizeName in this.mapSizes) {
        if (this.mapSizes.hasOwnProperty(mapSizeName)) {
          var mapSize = this.mapSizes[mapSizeName];
          this.addOptionElement(mapSizeName, mapSize);
        }
      }

      this.selectElement.className = this.displayClass + 'SelectElement';
      this.updateSize();

      this.selectElement.onchange = OpenLayers.Function
          .bindAsEventListener(this.onChange, this);

      this.div.appendChild(this.selectElement);
    }
    return div;
  },
  addOptionElement : function(sizeName, size) {
    var optionElement = document.createElement('option');
    optionElement.value = sizeName;
    optionElement.innerHTML = sizeName;
    this.selectElement.appendChild(optionElement);
    this.mapSizeOptionElements[sizeName] = optionElement;
    return optionElement;
  },
  removeOptionElement : function(sizeName) {
    var optionElement = this.mapSizeOptionElements[sizeName];
    if (Legato.Lang.ObjectUtils.exists(optionElement)) {
      this.selectElement.removeChild(optionElement);
      delete this.mapSizeOptionElements[sizeName];
    }
  },
  updateSize : function() {
    var currentSize = this.map.size;
    var currentSizeName = null;
    for ( var mapSizeName in this.mapSizes) {
      if (this.mapSizes.hasOwnProperty(mapSizeName)) {
        var mapSize = this.mapSizes[mapSizeName];
        if (Legato.Lang.ObjectUtils.exists(currentSize)
            && mapSize.equals(currentSize)) {
          currentSizeName = mapSizeName;
        }
      }
    }

    if (currentSizeName !== null) {
      if (currentSizeName != this.selectElement.value) {
        this.selectElement.value = currentSizeName;
      }
      this.removeOptionElement(this.customMapSizeName);
      delete this.mapSizes[this.customMapSizeName];
    } else {
      this.mapSizes[this.customMapSizeName] = currentSize;
      this.addOptionElement(this.customMapSizeName, currentSize);
      this.selectElement.value = this.customMapSizeName;
    }
  },
  onChange : function() {
    var mapSizeName = this.selectElement.value;
    if (Legato.Lang.ObjectUtils.exists(mapSizeName)) {
      var mapSize = this.mapSizes[mapSizeName];
      if (Legato.Lang.ObjectUtils.exists(mapSize)) {
        var extent = this.maintainExtent ? this.map.getExtent() : null;
        this.map.div.style.width = mapSize.w + 'px';
        this.map.div.style.height = mapSize.h + 'px';
        if (Legato.Lang.ObjectUtils.exists(extent)) {
          this.map.zoomToExtent(extent, this.zoomToClosest);
        }
        this.map.updateSize();
      }
    }
  },
  setMap : function(map) {
    OpenLayers.Control.prototype.setMap.apply(this, arguments);
    this.map.events.on({
      'moveend' : this.updateSize,
      scope : this
    });
  },
  destroy : function() {
    if (this.selectElement !== null) {
      this.selectElement.onchange = null;
    }
    this.map.events.un({
      'moveend' : this.updateSize,
      scope : this
    });
    this.selectElement = null;
    this.mapSizes = null;
    this.mapSizeOptionElements = null;
    this.otherMapSizeName = null;
    OpenLayers.Control.prototype.destroy.apply(this, arguments);
  },
  CLASS_NAME : "Legato.Control.SetMapSize"
});

/**
 * Component: lc:SetMapSize
 *
 * Inherits from:
 * - {<olc:Control>}
 *
 * See also:
 * - <lc> namespace
 * - {<Legato.Control.SetMapSize>}
 */
Legato.Control.SetMapSize.Bean = OpenLayers.Control.Bean.Extend(

'Legato.Control.SetMapSize',

Legato.Control.QName('SetMapSize'), {
  _constructor : Legato.Control.SetMapSize,
  options : {
    /**
     * Element: mapSizes
     * {<ol:Size> {}} Map (title/size) of map sizes.
     */
    mapSizes : OpenLayers.Size.Bean.Map(),
    /**
     * Element: maintainExtent
     * {Boolean}
     */
    maintainExtent : Legato.Lang.Boolean,
    /**
     * Element: zoomToClosest
     * {Boolean}
     */
    zoomToClosest : Legato.Lang.Boolean,

    /**
     * Element: defaultMapSizeLabel
     * {String}
     */
    customMapSizeName : Legato.Lang.String
  }
});
