/*
 * Legato is a configurable, lightweight web mapping client that can be
 * easily embedded into web pages and portals, CMS and individual web
 * applications. Legato is implemented in JavaScript and based on the
 * popular open source library OpenLayers.
 *
 * Copyright (C) 2010  disy Informationssysteme GmbH, http://www.disy.net
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

Hello = {};

Hello.World = {};

Hello.World.Message = OpenLayers.Class(OpenLayers.Control, {
	type : OpenLayers.Control.TYPE_BUTTON,
	text : null,

	initialize : function(options) {
		OpenLayers.Control.prototype.initialize.apply(this, [ options ]);
		Legato.Util.Ensure.ensureString(this.text,
				'The [text] configuration property is missing.');
	},

	trigger : function() {
		alert(this.text);
	},

	CLASS_NAME : 'Hello.World.Message'
});

/**
 * Component hw:Message.
 * 
 * Configuration example:
 * (start code)
 * <hw:Message xmlns:hw="http://www.disy.net/legato/hello/world" text="Hello, World!"/>
 * (end)
 */
Hello.World.Message.Bean = OpenLayers.Control.Bean.Extend(
		'Hello.World.Message', new Legato.XML.QName(
				'http://www.disy.net/legato/hello/world', 'Message', 'hw'), {
			_constructor : Hello.World.Message,
			options : {
				/**
				 * Element: text
				 * {String}
				 */
				text : Legato.Lang.String
			}
		});