/*
 * Decompiled with CFR 0.152.
 */
package net.disy.legato.tools.jts;

import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.MultiLineString;
import java.text.MessageFormat;
import net.disy.legato.tools.jts.AbstractGeometryConverter;
import net.disy.legato.tools.jts.LineStringConverter;
import org.directwebremoting.extend.MarshallException;

public class MultiLineStringConverter
extends AbstractGeometryConverter<MultiLineString, double[][][]> {
    private final LineStringConverter converter = new LineStringConverter();

    @Override
    protected String getGeometryType() {
        return "MultiLineString";
    }

    @Override
    protected Class<double[][][]> getCoordinatesType() {
        return double[][][].class;
    }

    @Override
    protected double[][][] createCoordinates(MultiLineString geometry) throws MarshallException {
        if (geometry == null) {
            return null;
        }
        if (geometry.isEmpty()) {
            return new double[0][0][0];
        }
        double[][][] coordinates = new double[geometry.getNumGeometries()][][];
        for (int index = 0; index < coordinates.length; ++index) {
            coordinates[index] = this.converter.createCoordinates((LineString)geometry.getGeometryN(index));
        }
        return coordinates;
    }

    @Override
    protected MultiLineString createGeometry(double[][][] coordinates) throws MarshallException {
        if (coordinates == null) {
            return null;
        }
        if (coordinates.length > 0) {
            LineString[] geometries = new LineString[coordinates.length];
            for (int index = 0; index < coordinates.length; ++index) {
                geometries[index] = this.converter.createGeometry(coordinates[index]);
            }
            return this.getGeometryFactory().createMultiLineString(geometries);
        }
        throw new MarshallException(MultiLineString.class, MessageFormat.format("Incorrect number of coordinate components [{0}].", coordinates.length));
    }
}

