/*
 * Decompiled with CFR 0.152.
 */
package net.disy.ogc.wps.v_1_0_0.sample;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.LinearRing;
import com.vividsolutions.jts.geom.Polygon;
import net.disy.ogc.wps.v_1_0_0.annotation.InputParameter;
import net.disy.ogc.wps.v_1_0_0.annotation.Metadata;
import net.disy.ogc.wps.v_1_0_0.annotation.OutputParameter;
import net.disy.ogc.wps.v_1_0_0.annotation.Process;
import net.disy.ogc.wps.v_1_0_0.annotation.ProcessMethod;
import net.opengis.ows.v_1_1_0.BoundingBoxType;
import org.apache.commons.lang.Validate;

@Process(id="boundingBoxTextPolygon", title="Bounding box and text to polygon", description="Returns current bounding box as polygon and takes another text parameter", metadata={@Metadata(about="tag", href="wps-demo:form"), @Metadata(about="tag", href="wps-demo:toolbar")})
public class BoundingBoxAndTextToPolygonAnnotatedObject {
    @ProcessMethod
    @OutputParameter(id="polygon", title="Polygon", description="Polygon for the current bounding box")
    public Polygon boundingBoxToPolygon(@InputParameter(id="boundingBox", title="Bounding box", description="Current") BoundingBoxType input, @InputParameter(id="text", title="Text", description="text parameter") String text) {
        Validate.notNull((Object)input);
        Validate.isTrue((boolean)input.isSetLowerCorner());
        Validate.isTrue((input.getLowerCorner().size() >= 2 ? 1 : 0) != 0);
        Validate.isTrue((input.getLowerCorner().get(0) != null ? 1 : 0) != 0);
        Validate.isTrue((input.getLowerCorner().get(1) != null ? 1 : 0) != 0);
        Validate.isTrue((input.getUpperCorner().size() >= 2 ? 1 : 0) != 0);
        Validate.isTrue((input.getUpperCorner().get(0) != null ? 1 : 0) != 0);
        Validate.isTrue((input.getUpperCorner().get(1) != null ? 1 : 0) != 0);
        double _x1 = (Double)input.getLowerCorner().get(0);
        double _y1 = (Double)input.getLowerCorner().get(1);
        double _x2 = (Double)input.getUpperCorner().get(0);
        double _y2 = (Double)input.getUpperCorner().get(1);
        double x1 = Math.min(_x1, _x2);
        double y1 = Math.min(_y1, _y2);
        double x2 = Math.max(_x1, _x2);
        double y2 = Math.max(_y1, _y2);
        Coordinate[] coordinates = new Coordinate[]{new Coordinate(x1, y1), new Coordinate(x2, y1), new Coordinate(x2, y2), new Coordinate(x1, y2), new Coordinate(x1, y1)};
        GeometryFactory geometryFactory = new GeometryFactory();
        return geometryFactory.createPolygon(geometryFactory.createLinearRing(coordinates), new LinearRing[0]);
    }
}

