/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.ogc.gml.v_3_1_1.jts;

import com.vividsolutions.jts.geom.Point;
import javax.xml.bind.JAXBElement;
import net.opengis.gml.v_3_1_1.DirectPositionType;
import net.opengis.gml.v_3_1_1.PointPropertyType;
import net.opengis.gml.v_3_1_1.PointType;
import org.jvnet.ogc.gml.v_3_1_1.ObjectFactoryInterface;
import org.jvnet.ogc.gml.v_3_1_1.jts.AbstractJTSToGML311Converter;
import org.jvnet.ogc.gml.v_3_1_1.jts.JTSToGML311CoordinateConverter;
import org.jvnet.ogc.gml.v_3_1_1.jts.JTSToGML311SRSReferenceGroupConverterInterface;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JTSToGML311PointConverter
extends AbstractJTSToGML311Converter<PointType, PointPropertyType, Point> {
    private final JTSToGML311CoordinateConverter coordinateConverter;

    public JTSToGML311PointConverter(ObjectFactoryInterface objectFactory, JTSToGML311SRSReferenceGroupConverterInterface srsReferenceGroupConverter, JTSToGML311CoordinateConverter coordinateConverter) {
        super(objectFactory, srsReferenceGroupConverter);
        this.coordinateConverter = coordinateConverter;
    }

    @Override
    protected PointType doCreateGeometryType(Point point) {
        PointType resultPoint = this.getObjectFactory().createPointType();
        if (!point.isEmpty()) {
            DirectPositionType directPosition = this.coordinateConverter.convertCoordinate(point.getCoordinate());
            resultPoint.setPos(directPosition);
        }
        return resultPoint;
    }

    @Override
    public PointPropertyType createPropertyType(Point point) {
        PointPropertyType pointPropertyType = this.getObjectFactory().createPointPropertyType();
        pointPropertyType.setPoint((PointType)this.createGeometryType(point));
        return pointPropertyType;
    }

    @Override
    public JAXBElement<PointType> createElement(Point point) {
        return this.getObjectFactory().createPoint((PointType)this.createGeometryType(point));
    }
}

