/*
 * Legato is a configurable, lightweight web mapping client that can be
 * easily embedded into web pages and portals, CMS and individual web
 * applications. Legato is implemented in JavaScript and based on the
 * popular open source library OpenLayers.
 *
 * Copyright (C) 2010  disy Informationssysteme GmbH, http://www.disy.net
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

WPSPD.Result.Point = OpenLayers.Class(WPSPD.Result.Geometry, {
  point : null,

  initialize : function(id, map, coordinates, symbolizer, options) {
    WPSPD.Result.Geometry.prototype.initialize.apply(this, [ id, map, symbolizer, options ]);
    point = new WPS.Result.Point(id, map, coordinates, options);
  },

  destroy : function() {
    this.point = null;
    WPSPD.Result.Geometry.prototype.destroy.apply(this, arguments);
  },

  createResultGeometry : function() {
    return point.createResultGeometry();
  },

  configureStyle : function(style) {
    if (Legato.Lang.ObjectUtils.exists(this.symbolizer.graphic) && Legato.Lang.ObjectUtils.exists(this.symbolizer.graphic.externalGraphicOrMark)) {
      var externalGraphicOrMark = this.symbolizer.graphic.externalGraphicOrMark;
      for (index = 0; index < externalGraphicOrMark.length; index++) {
        var graphicElement = externalGraphicOrMark[index];
        if (Legato.Lang.ObjectUtils.exists(graphicElement.stroke)) {
          this.evaluateStyleConfiguration(graphicElement.stroke, style);
        }
        if (Legato.Lang.ObjectUtils.exists(graphicElement.fill)) {
          this.evaluateStyleConfiguration(graphicElement.fill, style);
        }
      }
    }
  },

  CLASS_NAME : 'WPSPD.Result.Point'

});