/*
 * Legato is a configurable, lightweight web mapping client that can be
 * easily embedded into web pages and portals, CMS and individual web
 * applications. Legato is implemented in JavaScript and based on the
 * popular open source library OpenLayers.
 *
 * Copyright (C) 2010  disy Informationssysteme GmbH, http://www.disy.net
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

WPS.Result.BoundingBox = OpenLayers.Class(WPS.Result,
  {
    map: null,
    bounds: null,
    closest: true,

    initialize : function(id, map, bounds, options) {
      WPS.Result.prototype.initialize.apply(
        this, [id, options ]
      );
      this.map = map;
      this.bounds = bounds;
      Legato.Util.Ensure.ensureExists(this.map, 'map should be defined');
      Legato.Util.Ensure.ensureExists(this.bounds, 'bounds should be defined');
    },

    zoomToExtent : function(extent) {
      if(!Legato.Lang.ObjectUtils.isObject(this.map) ||
         !Legato.Lang.ObjectUtils.isFunction(this.map.zoomToExtent)){
        throw new Legato.Lang.Exception('Could not execute the result because given map seems to be invalid');
      }

      this.map.zoomToExtent(extent, this.closest);
    },

    execute : function() {
      this.zoomToExtent(this.bounds);
      return;
    },

    destroy : function() {
      this.map = null;
      this.bounds = null;
      this.closest = null;
      WPS.Result.prototype.destroy.apply(this, arguments);
    },

    CLASS_NAME :'WPS.Result.BoundingBox'
  }
);

WPS.Result.BoundingBox.BoundingBoxFactory = OpenLayers.Class(
  WPS.Result.SimpleFactory, {

    createResult : function(id, outputData, options) {
      if(!Legato.Lang.ObjectUtils.isArray(outputData.data.boundingBoxData.lowerCorner) ||
         !Legato.Lang.ObjectUtils.isArray(outputData.data.boundingBoxData.upperCorner) ||
         outputData.data.boundingBoxData.lowerCorner.length !== 2 ||
         outputData.data.boundingBoxData.upperCorner.length !== 2){
        throw new Legato.Lang.Exception('outputData.data.boundingBoxData seems to be invalid');
      }

      var bounds = new OpenLayers.Bounds(
        outputData.data.boundingBoxData.lowerCorner[0],
        outputData.data.boundingBoxData.lowerCorner[1],
        outputData.data.boundingBoxData.upperCorner[0],
        outputData.data.boundingBoxData.upperCorner[1]);

      return new WPS.Result.BoundingBox(id, this.map, bounds, options);
    },

    CLASS_NAME :'WPS.Result.BoundingBox.BoundingBoxFactory'
});