/*
 * Legato is a configurable, lightweight web mapping client that can be
 * easily embedded into web pages and portals, CMS and individual web
 * applications. Legato is implemented in JavaScript and based on the
 * popular open source library OpenLayers.
 *
 * Copyright (C) 2010  disy Informationssysteme GmbH, http://www.disy.net
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

/**
 * Class: WPS.Control.GeoControlSyncGeometryEditor
 *
 * Switches geoInputControl on and off
 *
 * Inherits from:
 * - <WPS.Control>
 *
 */
WPS.Control.GeoControlSyncGeometryEditor = OpenLayers.Class(WPS.Control, {

  editor: null,

  syncEvent: null,

  initialize : function(options) {
    if (! options.displayClass) {
      options.displayClass = 'LegatoControlInvisible';
    }
    OpenLayers.Control.prototype.initialize.apply(this, arguments);

    if (Legato.Lang.ObjectUtils.exists(this.editor)) {
      this.editor.events.on({
        'activate': this.geoInputActivated,
        scope: this
      });
    }
  },

  geoInputActivated: function() {
    Legato.Util.fireDOMEvent(this.panel_div, "click");
  },

  destroy: function() {
    if (Legato.Lang.ObjectUtils.exists(this.editor)) {
      this.editor.events.un({
        'activate': this.geoInputActivated,
        scope: this
      });
    }
    OpenLayers.Control.prototype.destroy.apply(this, arguments);
  },


  /** Function: activate
   * Invoked when the control is activated in toggle mode
   */
  activate: function() {
    if (Legato.Lang.ObjectUtils.exists(this.editor)) {
      this.editor.activate();
    }
    WPS.Control.prototype.activate.apply(this, arguments);
  },

  /** Function: deactivate
   * Invoked when the control is deactivated in toggle mode
   */
  deactivate: function() {
    if (Legato.Lang.ObjectUtils.exists(this.editor)) {
      this.editor.deactivate();
    }
    WPS.Control.prototype.deactivate.apply(this, arguments);
  },

  CLASS_NAME :"WPS.Control.GeoControlSyncGeometryEditor"
});

/**
 * Structure: lwpsc:GeoControlSyncGeometryEditor
 * XML based config for a <WPS.Control.GeoControlSyncGeometryEditor>.
 *
 * See Also:
 * - <Legato.Control>
 * - <Legato.Beans.BeanFactory>
 * - <QName>
 *
 * A valid config example for a ToggleDiv would be:
 * (start code)
 * <lwpsc:GeoControlSyncGeometryEditor>
 * <editor>
 * <lb:Reference target="geometryEditor" />
 * </editor>
 * </lwpsc:GeoControlSyncGeometryEditor>
 * (end)
 */
WPS.Control.GeoControlSyncGeometryEditor.Bean = WPS.Control.Bean.Extend(
  'WPS.Control.GeoControlSyncGeometryEditor',
  //
  WPS.Control.QName('GeoControlSyncGeometryEditor'),
  //
  {
    _constructor : WPS.Control.GeoControlSyncGeometryEditor,
    options:
    {
      editor: WPS.Control.GeometryEditor
    }
});
