/*
 * Legato is a configurable, lightweight web mapping client that can be
 * easily embedded into web pages and portals, CMS and individual web
 * applications. Legato is implemented in JavaScript and based on the
 * popular open source library OpenLayers.
 *
 * Copyright (C) 2010  disy Informationssysteme GmbH, http://www.disy.net
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

Legato.XML.QName = Legato.Lang
    .Class( {
      namespaceURI :null,
      localPart :null,
      prefix :null,
      initialize : function(one, two, three) {
        var namespaceURI;
        var localPart;
        var prefix;

        if (typeof two == 'undefined') {
          namespaceURI = "";
          localPart = one;
          prefix = "";
        } else if (typeof three == 'undefined') {
          namespaceURI = one;
          localPart = two;
          prefix = "";
        } else {
          namespaceURI = one;
          localPart = two;
          prefix = three;
        }
        this.namespaceURI = namespaceURI;
        this.localPart = localPart;
        this.prefix = prefix;
      },
      toString : function() {
        var result = '';
        if (this.namespaceURI != '') {
          result = result + '{' + this.namespaceURI + '}';
        }
        if (this.prefix != '') {
          result = result + this.prefix + ':';
        }
        result = result + this.localPart;
        return result;
      },
      clone : function() {
        return new Legato.XML.QName(this.namespaceURI, this.localPart,
            this.prefix);
      },
      equals : function(that) {
        if (!that) {
          return false;
        } else {
          return (this.namespaceURI == that.namespaceURI)
              && (this.localPart == that.localPart);
        }

      },
      CLASS_NAME :"Legato.XML.QName"
    });
Legato.XML.QName.valueOf = function(qNameAsString) {
  var leftBracket = qNameAsString.indexOf('{');
  var rightBracket = qNameAsString.lastIndexOf('}');
  var namespaceURI;
  var prefixedName;
  if ((leftBracket === 0) && (rightBracket > 0)
      && (rightBracket < qNameAsString.length)) {
    namespaceURI = qNameAsString.substring(1, rightBracket);
    prefixedName = qNameAsString.substring(rightBracket + 1);
  } else {
    namespaceURI = '';
    prefixedName = qNameAsString;
  }
  var colonPosition = prefixedName.indexOf(':');
  var prefix;
  var localPart;
  if (colonPosition > 0 && colonPosition < prefixedName.length) {
    prefix = prefixedName.substring(0, colonPosition);
    localPart = prefixedName.substring(colonPosition + 1);
  } else {
    prefix = '';
    localPart = prefixedName;
  }
  return new Legato.XML.QName(namespaceURI, localPart, prefix);
};