/*
 * Legato is a configurable, lightweight web mapping client that can be
 * easily embedded into web pages and portals, CMS and individual web
 * applications. Legato is implemented in JavaScript and based on the
 * popular open source library OpenLayers.
 *
 * Copyright (C) 2010  disy Informationssysteme GmbH, http://www.disy.net
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

OpenLayers.Popup.MarginAwareFramedCloud =
  OpenLayers.Class(OpenLayers.Popup.FramedCloud, {
    getContentDivPadding: function() {

      //use cached value if we have it
      var contentDivPadding = this._contentDivPadding;
      if (!contentDivPadding) {

        if (this.div.parentNode === null) {
          //make the div invisible and add it to the page
            this.div.style.display = "none";
            document.body.appendChild(this.div);
        }

        //read the padding settings from css, put them in an OL.Bounds
        var _contentDivPadding = new OpenLayers.Bounds(
            OpenLayers.Element.getStyle(this.contentDiv, "padding-left"),
            OpenLayers.Element.getStyle(this.contentDiv, "padding-bottom"),
            OpenLayers.Element.getStyle(this.contentDiv, "padding-right"),
            OpenLayers.Element.getStyle(this.contentDiv, "padding-top")
        );

        var _contentDivMargin = new OpenLayers.Bounds(
            OpenLayers.Element.getStyle(this.contentDiv, "margin-left"),
            OpenLayers.Element.getStyle(this.contentDiv, "margin-bottom"),
            OpenLayers.Element.getStyle(this.contentDiv, "margin-right"),
            OpenLayers.Element.getStyle(this.contentDiv, "margin-top")
        );

        contentDivPadding  = new OpenLayers.Bounds(
            _contentDivPadding.left + _contentDivMargin.left,
            _contentDivPadding.bottom + _contentDivMargin.bottom,
            _contentDivPadding.right + _contentDivMargin.right,
            _contentDivPadding.top + _contentDivMargin.top
        );

        //cache the value
        this._contentDivPadding = contentDivPadding;

        if (this.div.parentNode === document.body) {
          //remove the div from the page and make it visible again
          document.body.removeChild(this.div);
          this.div.style.display = "";
        }
      }
      return contentDivPadding;
    },
    CLASS_NAME: "OpenLayers.Popup.MarginAwareFramedCloud"
  });