/*
 * Legato is a configurable, lightweight web mapping client that can be
 * easily embedded into web pages and portals, CMS and individual web
 * applications. Legato is implemented in JavaScript and based on the
 * popular open source library OpenLayers.
 *
 * Copyright (C) 2010  disy Informationssysteme GmbH, http://www.disy.net
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

OpenLayers.Popup.prototype.getSafeContentSize = function(size) {

  var safeContentSize = size.clone();

  // if our contentDiv has a css 'padding' set on it by a stylesheet, we
  //  must add that to the desired "size".
  var contentDivPadding = this.getContentDivPadding();
  var contentDivMargin = this.getContentDivMargin();
  var wMargin = contentDivMargin.left + contentDivMargin.right;
  var hMargin = contentDivMargin.top + contentDivMargin.bottom;
  var wPadding = contentDivPadding.left + contentDivPadding.right;
  var hPadding = contentDivPadding.top + contentDivPadding.bottom;

  // take into account the popup's 'padding' property
  this.fixPadding();
  wPadding += this.padding.left + this.padding.right;
  hPadding += this.padding.top + this.padding.bottom;

  if (this.closeDiv) {
      var closeDivWidth = parseInt(this.closeDiv.style.width, 10);
      wPadding += closeDivWidth + contentDivPadding.right;
  }

  // prevent the popup from being smaller than a specified minimal size
  if (this.minSize) {
      safeContentSize.w = Math.max(safeContentSize.w,
          (this.minSize.w - wPadding - wMargin));
      safeContentSize.h = Math.max(safeContentSize.h,
          (this.minSize.h - hPadding - hMargin));
  }

  // prevent the popup from being bigger than a specified maximum size
  if (this.maxSize) {
      safeContentSize.w = Math.min(safeContentSize.w,
          (this.maxSize.w - wPadding - wMargin));
      safeContentSize.h = Math.min(safeContentSize.h,
          (this.maxSize.h - hPadding - hMargin));
  }

  //make sure the desired size to set doesn't result in a popup that
  // is bigger than the map's viewport.
  //
  if (this.map && this.map.size) {

      var extraX = 0, extraY = 0;
      if (this.keepInMap && !this.panMapIfOutOfView) {
          var px = this.map.getPixelFromLonLat(this.lonlat);
          switch (this.relativePosition) {
              case "tr":
                  extraX = px.x;
                  extraY = this.map.size.h - px.y;
                  break;
              case "tl":
                  extraX = this.map.size.w - px.x;
                  extraY = this.map.size.h - px.y;
                  break;
              case "bl":
                  extraX = this.map.size.w - px.x;
                  extraY = px.y;
                  break;
              case "br":
                  extraX = px.x;
                  extraY = px.y;
                  break;
              default:
                  extraX = px.x;
                  extraY = this.map.size.h - px.y;
                  break;
          }
      }

      var maxY = this.map.size.h -
          this.map.paddingForPopups.top -
          this.map.paddingForPopups.bottom -
          hPadding - extraY;

      var maxX = this.map.size.w -
          this.map.paddingForPopups.left -
          this.map.paddingForPopups.right -
          wPadding - extraX;

      safeContentSize.w = Math.min(safeContentSize.w, maxX);
      safeContentSize.h = Math.min(safeContentSize.h, maxY);
  }

  return safeContentSize;
};

OpenLayers.Popup.prototype.getContentDivMargin = function() {

    if (this.div.parentNode === null) {
      //make the div invisible and add it to the page
        this.div.style.display = "none";
        document.body.appendChild(this.div);
  }

      //read the padding settings from css, put them in an OL.Bounds
      contentDivMargin = new OpenLayers.Bounds(
          OpenLayers.Element.getStyle(this.contentDiv, "margin-left"),
          OpenLayers.Element.getStyle(this.contentDiv, "margin-bottom"),
          OpenLayers.Element.getStyle(this.contentDiv, "margin-right"),
          OpenLayers.Element.getStyle(this.contentDiv, "margin-top")
      );

      if (this.div.parentNode == document.body) {
        //remove the div from the page and make it visible again
        document.body.removeChild(this.div);
        this.div.style.display = "";
      }

  return contentDivMargin;
};