/*
 * Legato is a configurable, lightweight web mapping client that can be
 * easily embedded into web pages and portals, CMS and individual web
 * applications. Legato is implemented in JavaScript and based on the
 * popular open source library OpenLayers.
 *
 * Copyright (C) 2010  disy Informationssysteme GmbH, http://www.disy.net
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

Legato.Handler.Box = OpenLayers.Class(OpenLayers.Handler.Box, {
  endBox : function(end) {
    var result;
    if (Math.abs(this.dragHandler.start.x - end.x) > 5
        || Math.abs(this.dragHandler.start.y - end.y) > 5) {
      var start = this.dragHandler.start;
      var top = Math.min(start.y, end.y);
      var bottom = Math.max(start.y, end.y);
      var left = Math.min(start.x, end.x);
      var right = Math.max(start.x, end.x);
      
      var lowerLeftLonLat = this.map.getLonLatFromPixel(new OpenLayers.Pixel(
          left, bottom));
      var upperRightLonLat = this.map.getLonLatFromPixel(new OpenLayers.Pixel(
          right, top));
      var bounds = new OpenLayers.Bounds(lowerLeftLonLat.lon,
          lowerLeftLonLat.lat, upperRightLonLat.lon, upperRightLonLat.lat);
      result = bounds.toGeometry();
    } else {
      var xy = this.dragHandler.start.clone();
      var lonLat = this.map.getLonLatFromPixel(xy);
      result = new OpenLayers.Geometry.Point(lonLat.lon, lonLat.lat);
    }
    this.removeBox();
    this.callback("done", [ result ]);
  },

  CLASS_NAME :"Legato.Handler.Box"
});