/*
 * Legato is a configurable, lightweight web mapping client that can be
 * easily embedded into web pages and portals, CMS and individual web
 * applications. Legato is implemented in JavaScript and based on the
 * popular open source library OpenLayers.
 *
 * Copyright (C) 2010  disy Informationssysteme GmbH, http://www.disy.net
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

Legato.Control.DrawText = OpenLayers.Class(Legato.Control.DrawPoint, {
  handlerConstructor : Legato.Handler.Point,
  textPrompt : function(callback) {
    var labelText = prompt(Legato.I18n.getMessage('Legato.Control.DrawText.TextPrompt'), 'TEXT');
    callback(labelText);
  },

  initialize : function(layer, options) {
    Legato.Control.DrawPoint.prototype.initialize.apply(this,
        [ layer, options ]);
  },
  drawFeature : function(geometry) {
    var that = this;
    this.textPrompt(function(label) {
      if (!Legato.Lang.StringUtils.isEmpty(label)) {
        var attributes = OpenLayers.Util.extend({}, that.attributes);
        var style = that.style !== null ? OpenLayers.Util.extend({}, that.style)
            : null;
        var feature = new OpenLayers.Feature.Vector(geometry, attributes, style);
        feature.style.label = label;
        var proceed = that.layer.events.triggerEvent('sketchcomplete', {
          feature : feature
        });
        if (proceed !== false) {
          feature.state = OpenLayers.State.INSERT;
          if (that.mode == 1) {
            that.layer.addFeatures([ feature ]);
            that.featureAdded(feature);
            that.events.triggerEvent('featureadded', {
              feature : feature
            });
          }
          if (that.mode == 2) {
            that.layer.destroyFeatures();
            that.layer.addFeatures([ feature ]);
            that.featureAdded(feature);
            that.events.triggerEvent('featureadded', {
              feature : feature
            });
          }
        }
        if (Legato.Lang.ObjectUtils.isFunction(this.callback)) {
          that.callback(geometry);
        }
      }
    });
  },
  CLASS_NAME : 'Legato.Control.DrawText'
});

Legato.Control.DrawPoint.Bean = Legato.Control.DrawFeature.Bean.Extend(
//
'Legato.Control.DrawText',
//
Legato.Control.QName('DrawText'),
//
{
  _constructor : Legato.Control.DrawPoint,
  constructorArguments : {
    layer : OpenLayers.Layer.Bean
  },
  constructorOrder : [ 'layer' ]
});