/*
 * Legato is a configurable, lightweight web mapping client that can be
 * easily embedded into web pages and portals, CMS and individual web
 * applications. Legato is implemented in JavaScript and based on the
 * popular open source library OpenLayers.
 *
 * Copyright (C) 2010  disy Informationssysteme GmbH, http://www.disy.net
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

/*
 * @author $Author: valikov $
 * @version $Rev: 70574 $
 */

/*
 * Class: Legato.Beans.Property
 * 
 * Models a property with type, setter and getter.
 */
Legato.Beans.Property = Legato.Lang.Class( {
  /*
   * Property: type
   * 
   * {<Legato.Lang.AnyType>} Type of the property.
   */
  type :null,
  /*
   * Property: setter
   * 
   * {Function} Setter function for the property.
   */
  setter :null,
  /*
   * Property: getter
   * 
   * {Function} Getter function for the property.
   */
  getter :null,
  /*
   * Constructor: initialize
   * 
   * Constructs a new property.
   * 
   * Parameters:
   * 
   * type - {<Legato.Lang.AnyType>} type of the property.
   * 
   * setter - {Function} setter function.
   *  
   * getter - {Function} getter function. 
   */
  initialize : function(type, setter, getter) {
    Legato.Util.Ensure.ensureObject(type);
    this.type = type;
    if (Legato.Lang.ObjectUtils.exists(setter)) {
      Legato.Util.Ensure.ensureFunction(setter);
      this.setter = setter;
    } else {
      this.setter = null;
    }
    if (Legato.Lang.ObjectUtils.exists(getter)) {
      Legato.Util.Ensure.ensureFunction(getter);
      this.getter = getter;
    } else {
      this.getter = null;
    }
  },
  /*
   * Function: set
   * 
   * Sets value to the given object instance. Throws {<Legato.Lang.Exception>}
   * for read-only property.
   * 
   * Parameters:
   * 
   * instance - instance to set value to.
   * 
   * value - value to be set.
   * 
   */
  set : function(instance, value) {
    Legato.Util.Ensure.ensureExists(instance);
    if (Legato.Lang.ObjectUtils.exists(this.setter)) {
      this.setter(instance, value);
    } else {
      throw new Legato.Lang.Exception(
          'Could not set the value, setter function is not provided.');
    }
  },
  /*
   * Function: get
   * 
   * Gets value from the given object instance. Throws {<Legato.Lang.Exception>}
   * for write-only property.
   * 
   * Returns:
   * 
   * Value of the instance property returned by the getter function.
   * 
   * Parameters:
   * 
   * instance - instance to set value to.
   * 
   */
  get : function(instance) {
    Legato.Util.Ensure.ensureExists(instance);
    if (Legato.Lang.ObjectUtils.exists(this.getter)) {
      this.getter(instance);
    } else {
      throw new Legato.Lang.Exception(
          'Could not set the value, setter function is not provided.');
    }
  }
});