/*
 * Legato is a configurable, lightweight web mapping client that can be
 * easily embedded into web pages and portals, CMS and individual web
 * applications. Legato is implemented in JavaScript and based on the
 * popular open source library OpenLayers.
 *
 * Copyright (C) 2010  disy Informationssysteme GmbH, http://www.disy.net
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

/**
 * Component: <olc:ModifyFeature>
 * 
 * Allows modifying features.
 *
 * Inherits From:
 *  - <olc:Control>
 *  
 *  See also:
 *  - <olc> namespace
 * - <lc:ModifyFeature>
 * - <lc:ModifyPoint>
 * - <lc:ModifyLineString>
 * - <lc:ModifyPolygon>
 * - <lc:DrawFeature>
 * - <lc:DrawPoint>
 * - <lc:DrawLineString>
 * - <lc:DrawPolygon>
 * - <lc:DrawBox>
 */
OpenLayers.Control.ModifyFeature.Bean = OpenLayers.Control.Bean.Extend(
//
'OpenLayers.Control.ModifyFeature',
//
Legato.OpenLayers.Control.QName('ModifyFeature'),
//
{
	_constructor : OpenLayers.Control.ModifyFeature,
	constructorArguments : {
		/**
		 * Element: layer
		 * {<oll:Vector>} 
		 */
		layer : OpenLayers.Layer.Bean
	},
	constructorOrder : [ 'layer' ],
	options : {
		/**
		 * Element: featureAdded
		 * {Function} Called after the feature is added
		 */
		featureAdded : Legato.Lang.Function,
		/**
		 * Element: handlerOptions
		 * {Object} Used to set non-default properties on the control's handler
		 */
		handlerOptions : Legato.Beans.Object,
		/**
		 * Element: geometryTypes
		 * {String []} To restrict modification to a limited set of geometry
		 * types, send a list of strings corresponding to the geometry class
		 * names.
		 */
		geometryTypes : Legato.Lang['String[]'],
		/**
		 * Element: clickout
		 * {Boolean} Unselect features when clicking outside any feature.
		 * Default is true.
		 */
		clickout : Legato.Lang.Boolean,
		/**
		 * Element: toggle
		 * {Boolean} Unselect a selected feature on click. Default is true.
		 */
		toggle : Legato.Lang.Boolean,

		/**
		 * Element: deleteCodes
		 * {Integer []} Keycodes for deleting verticies.
		 */
		deleteCodes : Legato.Lang['Integer[]'],

		/**
		 * APIProperty: virtualStyle
		 * {Object} A symbolizer to be used for virtual vertices.
		 */
		virtualStyle : Legato.Beans.Object,

		/**
		 * APIProperty: mode
		 * {Integer} Bitfields specifying the modification mode.
		 */
		mode : Legato.Lang.Integer
	}
});