/*
 * Legato is a configurable, lightweight web mapping client that can be
 * easily embedded into web pages and portals, CMS and individual web
 * applications. Legato is implemented in JavaScript and based on the
 * popular open source library OpenLayers.
 *
 * Copyright (C) 2010  disy Informationssysteme GmbH, http://www.disy.net
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

/**
 * @author $Author: leine $
 * @version $Rev: 72369 $
 * @base Legato.Control.Legend.Plugin
 * @requires Legato/Control.js
 * @requires Legato/Legend.js
 * @requires Legato/Legend/Plugin.js
 */

/**
 * Class: Legato.Control.Legend.Plugin.LayerPosition
 * Abstract legend plugin control.
 */
Legato.Control.Legend.Plugin.LayerPosition = OpenLayers.Class(
		Legato.Control.Legend.Plugin, {

			/**
			 * Function: create
			 */
			afterSetup : function() {
				this.div.onclick = OpenLayers.Function.bindAsEventListener(
						this.onclick, this);
			},

			/**
			 * Function: beforeDestroyed
			 */
			beforeDestroyed : function() {
				this.div.onclick = null;
			},

			/**
			 * Function: onclick abstract method. Implemented by subclasses.
			 */
			onclick : function(event) {
				if (Legato.Lang.ObjectUtils.exists(event)) {
					OpenLayers.Event.stop(event, true);
				}
			},

			/**
			 * Function: raiseLayer
			 */
			raiseLayer : function(layer, step, filter) {
				var map = this.map;
				var layers = this.map.layers;
				var index = map.getLayerIndex(layer) + step;
				while (index >= 0 && index < layers.length) {
					if (filter(layers[index])) {
						map.setLayerIndex(layer, index);
						return;
					} else {
						index = index + step;
					}
				}
			},
			CLASS_NAME : 'Legato.Control.Legend.Plugin.LayerPosition'
		});

/**
 * Class: Legato.Control.Legend.Plugin.LayerPosition.Factory Abstract factory
 * base class.
 */
Legato.Control.Legend.Plugin.LayerPosition.Factory = OpenLayers.Class(
		Legato.Control.Legend.Plugin.Factory, {

			/**
			 * Function: create Factory method for creating a
			 * <Legato.Control.Legend.Plugin.LayerPosition> instance.
			 */
			create : function(layer) {
				return new Legato.Control.Legend.Plugin.LayerPosition(layer,
						this.pluginOptions);
			},

			/**
			 * Function: supports Just overlay layers are supported
			 */
			supports : function(layer) {
				return Legato.Control.Legend.Plugin.Factory.prototype.supports
						.apply(this, arguments)
						&& !layer.isBaseLayer;
			},

			CLASS_NAME : 'Legato.Control.Legend.Plugin.LayerPositionUp.Factory'
		});

/**
 * Class: Legato.Control.Legend.Plugin.LayerPositionUp
 */
Legato.Control.Legend.Plugin.LayerPositionUp = OpenLayers.Class(
		Legato.Control.Legend.Plugin.LayerPosition, {

			/**
			 * Function: onclick
			 */
			onclick : function(event) {
				this.raiseLayer(this.layer, 1,
						(this.layer.isBaseLayer ? this.isListedBaseLayer
								: this.isListedOverlay));
				// The event is stop to avoid containing div to react on "onclick"
				OpenLayers.Event.stop(event);
			},

			CLASS_NAME : 'Legato.Control.Legend.Plugin.LayerPositionUp'
		});

/**
 * Class: Legato.Control.Legend.Plugin.LayerPositionUp.Factory Factory class
 * wich is able to create a <Legato.Control.Legend.Plugin.LayerPositionUp>
 * instance.
 */
Legato.Control.Legend.Plugin.LayerPositionUp.Factory = OpenLayers.Class(
		Legato.Control.Legend.Plugin.LayerPosition.Factory, {

			/**
			 * Function: create Factory method for creating a
			 * <Legato.Control.Legend.Plugin.LayerPositionUp> instance.
			 */
			create : function(layer) {
				return new Legato.Control.Legend.Plugin.LayerPositionUp(layer,
						this.pluginOptions);
			},

			CLASS_NAME : 'Legato.Control.Legend.Plugin.LayerPositionUp.Factory'
		});

/**
 * Class: Legato.Control.Legend.Plugin.LayerPositionUp
 */
Legato.Control.Legend.Plugin.LayerPositionDown = OpenLayers.Class(
		Legato.Control.Legend.Plugin.LayerPosition, {

			/**
			 * Function: onclick
			 */
			onclick : function(event) {
				this.raiseLayer(this.layer, -1,
						(this.layer.isBaseLayer ? this.isListedBaseLayer
								: this.isListedOverlay));
				// The event is stop to avoid containing div to react on "onclick"
				OpenLayers.Event.stop(event);
			},

			CLASS_NAME : 'Legato.Control.Legend.Plugin.LayerPositionDown'
		});

/**
 * Class: Legato.Control.Legend.Plugin.LayerPositionUp.Factory Factory class
 * wich is able to create a <Legato.Control.Legend.Plugin.LayerPositionDown>
 * instance.
 */
Legato.Control.Legend.Plugin.LayerPositionDown.Factory = OpenLayers
		.Class(
				Legato.Control.Legend.Plugin.LayerPosition.Factory,
				{

					/**
					 * Function: create Factory method for creating a
					 * <Legato.Control.Legend.Plugin.LayerPositionDown> instance.
					 */
					create : function(layer) {
						return new Legato.Control.Legend.Plugin.LayerPositionDown(
								layer, this.pluginOptions);
					},
					CLASS_NAME : 'Legato.Control.Legend.Plugin.LayerPositionDown.Factory'
				});

/**
 * Component: llp:LayerPositionUp
 * 
 * Inherits from:
 * - <llp:Plugin>
 * 
 * See Also:
 * - <llp> namespace
 * - {<Legato.Control.Legend.Plugin.LayerPositionUp>}
 */
Legato.Control.Legend.Plugin.LayerPositionUp.Bean = Legato.Control.Legend.Plugin.Bean
		.Extend('Legato.Control.Legend.Plugin.LayerPositionUp.Factory',

		Legato.Control.Legend.Plugin.QName('LayerPositionUp'), {
			_constructor : Legato.Control.Legend.Plugin.LayerPositionUp.Factory
		});

/**
 * Component: llp:LayerPositionDown
 * 
 * Inherits from:
 * - <llp:Plugin>
 * 
 * See Also:
 * - <llp> namespace
 * - {<Legato.Control.Legend.Plugin.LayerPositionDown>}
 */
Legato.Control.Legend.Plugin.LayerPositionDown.Bean = Legato.Control.Legend.Plugin.Bean
		.Extend(

				'Legato.Control.Legend.Plugin.LayerPositionDown.Factory',

				Legato.Control.Legend.Plugin.QName('LayerPositionDown'),
				{
					_constructor : Legato.Control.Legend.Plugin.LayerPositionDown.Factory
				});