/*
 * Legato is a configurable, lightweight web mapping client that can be
 * easily embedded into web pages and portals, CMS and individual web
 * applications. Legato is implemented in JavaScript and based on the
 * popular open source library OpenLayers.
 *
 * Copyright (C) 2010  disy Informationssysteme GmbH, http://www.disy.net
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

function init()
{
  map = new OpenLayers.Map('map', { controls: [] });

  var bathymetry = new OpenLayers.Layer.WMS('Bathymetry',
    'http://www2.demis.nl/wms/wms.asp?wms=WorldMap&',
    { layers: 'Bathymetry'}); 

  var topography = new OpenLayers.Layer.WMS('Topography',
    'http://www2.demis.nl/wms/wms.asp?wms=WorldMap&',
    { layers: 'Topography', transparent: 'true'}); 

  map.addLayers([topography, bathymetry]);

  map.addControl(new OpenLayers.Control.Navigation());
  map.addControl(new OpenLayers.Control.PanZoomBar());

  map.zoomToExtent(new OpenLayers.Bounds(-16, 36, 37, 63.5), true);
}
