/*
 * Decompiled with CFR 0.152.
 */
package net.disy.ogc.wps.v_1_0_0.util;

import java.net.URL;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import net.disy.ogc.gml.v_3_1_1.GmlConstants;
import net.disy.ogc.wps.v_1_0_0.WpsConstants;
import net.disy.ogc.wpspd.v_1_0_0.WpspdConstants;
import net.opengis.ows.v_1_1_0.CodeType;
import net.opengis.ows.v_1_1_0.LanguageStringType;
import net.opengis.wps.v_1_0_0.ProcessBriefType;
import net.opengis.wps.v_1_0_0.ProcessDescriptionType;
import org.xml.sax.SAXException;

public class WpsUtils {
    private WpsUtils() {
    }

    public static ProcessBriefType createBriefDescription(ProcessDescriptionType processDescription) {
        ProcessBriefType briefProcessDescription = new ProcessBriefType();
        if (processDescription.getIdentifier() != null) {
            briefProcessDescription.setIdentifier(processDescription.getIdentifier());
        }
        if (processDescription.getTitle() != null) {
            briefProcessDescription.setTitle(processDescription.getTitle());
        }
        if (processDescription.getAbstract() != null) {
            briefProcessDescription.setAbstract(processDescription.getAbstract());
        }
        if (processDescription.getMetadata().isEmpty()) {
            briefProcessDescription.getMetadata().addAll(processDescription.getMetadata());
        }
        if (!processDescription.getProfile().isEmpty()) {
            briefProcessDescription.getProfile().addAll(processDescription.getProfile());
        }
        if (processDescription.getWSDL() != null) {
            briefProcessDescription.setWSDL(processDescription.getWSDL());
        }
        if (processDescription.getProcessVersion() != null) {
            briefProcessDescription.setProcessVersion(processDescription.getProcessVersion());
        }
        return briefProcessDescription;
    }

    public static CodeType createCodeType(String value) {
        CodeType code = new CodeType();
        code.setValue(value);
        return code;
    }

    public static LanguageStringType createLanguageStringType(String value) {
        LanguageStringType title = new LanguageStringType();
        title.setValue(value);
        return title;
    }

    public static Schema createSchema() throws SAXException {
        SchemaFactory schemaFactory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
        URL schemaResource = WpsUtils.class.getClassLoader().getResource("wps/1.0.0/wpsAll.xsd");
        Schema schema = schemaFactory.newSchema(new StreamSource(schemaResource.toString()));
        return schema;
    }

    public static JAXBContext createJaxbContext() throws JAXBException {
        JAXBContext context = JAXBContext.newInstance((String)(WpsConstants.CONTEXT_PATH + ":" + GmlConstants.CONTEXT_PATH + ":" + WpspdConstants.CONTEXT_PATH));
        return context;
    }
}

