/*
 * Decompiled with CFR 0.152.
 */
package net.disy.ogc.wps.v_1_0_0.sample;

import java.net.URL;
import java.text.MessageFormat;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import net.disy.ogc.wps.v_1_0_0.sample.ParameterlessAnnotatedObject;
import net.disy.ogc.wps.v_1_0_0.util.Validate;

public class SampleAnnotatedObject<T>
implements ParameterlessAnnotatedObject<T> {
    private final Class<T> outputParameterClass;
    private final T result;

    public SampleAnnotatedObject(JAXBContext context, Class<T> outputParameterClass, String resourceName) {
        Validate.notNull(context);
        Validate.notNull(outputParameterClass);
        Validate.notNull(resourceName);
        this.outputParameterClass = outputParameterClass;
        this.result = this.createResult(context, outputParameterClass, resourceName);
    }

    public Class<T> getOutputParameterClass() {
        return this.outputParameterClass;
    }

    private T createResult(JAXBContext context, Class<T> outputParameterClass, String resourceName) {
        URL resourceURL = this.getClass().getResource(resourceName);
        if (resourceURL == null) {
            throw new IllegalArgumentException(MessageFormat.format("Resource [{0}] could not be found.", resourceName));
        }
        try {
            Object object = context.createUnmarshaller().unmarshal(resourceURL);
            if (outputParameterClass.isAssignableFrom(object.getClass())) {
                return (T)object;
            }
            throw new IllegalArgumentException(MessageFormat.format("Unmarshalled object class [{0}] does not match the expected class [{1}].", object.getClass(), outputParameterClass));
        }
        catch (JAXBException jaxbex) {
            throw new IllegalArgumentException(MessageFormat.format("Resource [{0}] could not be parsed.", resourceName), jaxbex);
        }
    }

    @Override
    public T execute() {
        return this.result;
    }
}

