/*
 * Decompiled with CFR 0.152.
 */
package net.disy.ogc.wps.v_1_0_0.procedure;

import net.disy.ogc.wps.v_1_0_0.model.DataTypeTypeVisitor;
import net.disy.ogc.wps.v_1_0_0.model.Format;
import net.disy.ogc.wps.v_1_0_0.model.FormatId;
import net.disy.ogc.wps.v_1_0_0.model.LiteralType;
import net.disy.ogc.wps.v_1_0_0.procedure.OutputParameterDescription;
import net.disy.ogc.wps.v_1_0_0.procedure.WpsProcessContext;
import net.opengis.ows.v_1_1_0.BoundingBoxType;
import net.opengis.wps.v_1_0_0.ComplexDataType;
import net.opengis.wps.v_1_0_0.DataType;
import net.opengis.wps.v_1_0_0.ExecuteResponse;
import net.opengis.wps.v_1_0_0.LiteralDataType;
import net.opengis.wps.v_1_0_0.OutputDataType;
import net.opengis.wps.v_1_0_0.OutputDescriptionType;

public class ProcessOutputBuilder {
    private final ExecuteResponse.ProcessOutputs processOutputs;
    private final WpsProcessContext context;

    public ProcessOutputBuilder(WpsProcessContext context) {
        this.context = context;
        this.processOutputs = context.getWpsObjectFactory().createExecuteResponseProcessOutputs();
    }

    public ExecuteResponse.ProcessOutputs getProcessOutputs() {
        return this.processOutputs;
    }

    public <S, D> void addOutput(OutputDescriptionType outputDescription, OutputParameterDescription outputParameter, Class<D> outputClass, Object result) {
        OutputDataType output = this.context.getWpsObjectFactory().createOutputDataType();
        output.setIdentifier(outputDescription.getIdentifier());
        output.setTitle(outputDescription.getTitle());
        output.setAbstract(outputDescription.getAbstract());
        this.processOutputs.getOutput().add(output);
        final net.disy.ogc.wps.v_1_0_0.model.DataType<?> dataType = this.context.getDataTypeHelper().getDataType(outputParameter, outputClass);
        final Object convertedResult = this.context.getConverterRegistry().convertFrom(dataType.getTargetClass(), outputClass, result);
        final DataType outputData = this.context.getWpsObjectFactory().createDataType();
        dataType.getType().accept(new DataTypeTypeVisitor(){

            @Override
            public void visitLiteral() {
                ProcessOutputBuilder.this.addLiteralData(outputData, dataType, convertedResult);
            }

            @Override
            public void visitComplex() {
                ProcessOutputBuilder.this.addComplexData(outputData, dataType, convertedResult);
            }

            @Override
            public void visitBBox() {
                outputData.setBoundingBoxData((BoundingBoxType)convertedResult);
            }
        });
        output.setData(outputData);
    }

    private <S> void addLiteralData(DataType outputData, net.disy.ogc.wps.v_1_0_0.model.DataType<S> dataType, S convertedResult) {
        LiteralDataType literalOutputDataType = this.context.getWpsObjectFactory().createLiteralDataType();
        outputData.setLiteralData(literalOutputDataType);
        LiteralType<S> literalType = this.context.getLiteralTypeRegistry().getLiteralType(dataType);
        String stringValue = literalType.toString(convertedResult);
        literalOutputDataType.setValue(stringValue);
    }

    private <S> void addComplexData(DataType outputData, net.disy.ogc.wps.v_1_0_0.model.DataType<S> dataType, S convertedResult) {
        ComplexDataType complexData = this.context.getWpsObjectFactory().createComplexDataType();
        outputData.setComplexData(complexData);
        Format<S> format = this.context.getFormatRegistry().getDefaultFormat(dataType);
        FormatId formatId = format.getFormatId();
        complexData.setEncoding(formatId.getEncoding());
        complexData.setMimeType(formatId.getMimeType());
        complexData.setSchema(formatId.getSchemaDesignator());
        complexData.setContent(format.marshal(convertedResult));
    }
}

