/*
 * Decompiled with CFR 0.152.
 */
package net.disy.ogc.wps.v_1_0_0.procedure;

import java.text.MessageFormat;
import net.disy.ogc.wps.v_1_0_0.converter.TypeConverterRegistry;
import net.disy.ogc.wps.v_1_0_0.model.DataType;
import net.disy.ogc.wps.v_1_0_0.model.DataTypeRegistry;
import net.disy.ogc.wps.v_1_0_0.model.DefaultDataType;
import net.disy.ogc.wps.v_1_0_0.model.XmlSchemaConstants;
import net.disy.ogc.wps.v_1_0_0.procedure.DataTypeHelper;
import net.disy.ogc.wps.v_1_0_0.procedure.ParameterDescription;
import net.disy.ogc.wps.v_1_0_0.procedure.ParameterType;

public class DefaultDataTypeHelper
implements DataTypeHelper {
    private final DataTypeRegistry dataTypeRegistry;
    private final TypeConverterRegistry converterRegistry;

    public DefaultDataTypeHelper(DataTypeRegistry dataTypeRegistry, TypeConverterRegistry converterRegistry) {
        this.dataTypeRegistry = dataTypeRegistry;
        this.converterRegistry = converterRegistry;
    }

    @Override
    public DataType<?> getDataType(ParameterDescription parameterDescription, Class<?> typeClass) {
        DataType<?> dataType;
        ParameterType parameterType = parameterDescription.getParameterType();
        Class<?> componentType = this.getComponentType(typeClass);
        if (ParameterType.Default.equals((Object)parameterType)) {
            String schemaDesignator;
            net.disy.ogc.wps.v_1_0_0.annotation.DataType dt = parameterDescription.getDataType();
            DataType<?> defaultDataType = null;
            if ("##default".equals(dt.schemaDesignator())) {
                defaultDataType = this.dataTypeRegistry.getDefaultDataType(componentType);
            } else {
                try {
                    defaultDataType = this.dataTypeRegistry.getDataType(dt.schemaDesignator());
                }
                catch (IllegalArgumentException iaex) {
                    try {
                        defaultDataType = this.dataTypeRegistry.getDefaultDataType(componentType);
                    }
                    catch (IllegalArgumentException iaex1) {
                        defaultDataType = this.dataTypeRegistry.getDataType(XmlSchemaConstants.ANY_TYPE_SCHEMA_DESIGNATOR);
                    }
                }
            }
            String string = schemaDesignator = "##default".equals(dt.schemaDesignator()) ? defaultDataType.getSchemaDesignator() : dt.schemaDesignator();
            dataType = schemaDesignator.equals(defaultDataType.getSchemaDesignator()) ? defaultDataType : new DefaultDataType(schemaDesignator, defaultDataType.getTargetClass(), defaultDataType.getType());
        } else {
            dataType = parameterType.getDataType(this.dataTypeRegistry, componentType);
        }
        if (dataType == null) {
            throw new IllegalArgumentException(MessageFormat.format("Could not create the datatype for parameter description [{0}] and type class [{1}].", parameterDescription, typeClass));
        }
        if (!this.converterRegistry.isConversionSupported(dataType.getTargetClass(), componentType)) {
            throw new IllegalArgumentException(MessageFormat.format("Wrong type [{0}] for schema designator [{1}], could not find the appropriate converter.", componentType.getName(), dataType.getSchemaDesignator()));
        }
        return dataType;
    }

    private Class<?> getComponentType(Class<?> typeClass) {
        if (typeClass.isArray()) {
            return typeClass.getComponentType();
        }
        return typeClass;
    }
}

