/*
 * Decompiled with CFR 0.152.
 */
package net.disy.ogc.wps.v_1_0_0.model;

import java.util.HashMap;
import java.util.Map;
import net.disy.ogc.wps.v_1_0_0.converter.SingleItemTypeConverter;
import net.disy.ogc.wps.v_1_0_0.model.DataType;
import net.disy.ogc.wps.v_1_0_0.model.DefaultFormat;
import net.disy.ogc.wps.v_1_0_0.model.Format;
import net.disy.ogc.wps.v_1_0_0.model.FormatId;
import net.disy.ogc.wps.v_1_0_0.model.FormatRegistry;
import net.disy.ogc.wps.v_1_0_0.util.Validate;

public class DefaultFormatRegistry
implements FormatRegistry {
    private final Map<DataType<?>, Format<?>> defaultFormatsByDataType = new HashMap();
    private final Map<FormatId, Format<?>> formatsById = new HashMap();

    @Override
    public <T> Format<T> getDefaultFormat(DataType<T> dataType) throws IllegalArgumentException {
        org.apache.commons.lang.Validate.notNull(dataType);
        if (this.defaultFormatsByDataType.containsKey(dataType)) {
            Format<?> format = this.defaultFormatsByDataType.get(dataType);
            return format;
        }
        return new DefaultFormat<T>(dataType, new FormatId("text/xml", "utf-8", dataType.getSchemaDesignator()), new SingleItemTypeConverter<T>(dataType.getTargetClass()));
    }

    public <T> void addDefaultFormat(Format<?> format) {
        org.apache.commons.lang.Validate.notNull(format);
        Validate.notContains(this.defaultFormatsByDataType, format.getDataType());
        this.defaultFormatsByDataType.put(format.getDataType(), format);
    }

    public void addFormat(Format<?> format) {
        org.apache.commons.lang.Validate.notNull(format);
        Validate.notContains(this.formatsById, format.getFormatId());
        this.formatsById.put(format.getFormatId(), format);
    }
}

