/*
 * Decompiled with CFR 0.152.
 */
package net.disy.ogc.wps.v_1_0_0;

import java.util.Locale;
import net.disy.ogc.ows.v_1_1_0.InvalidParameterValueException;
import net.disy.ogc.ows.v_1_1_0.MissingParameterValueException;
import net.disy.ogc.ows.v_1_1_0.OwsException;
import net.disy.ogc.wps.v_1_0_0.ExecuteService;
import net.disy.ogc.wps.v_1_0_0.WpsProcess;
import net.disy.ogc.wps.v_1_0_0.WpsProcessRegistry;
import net.opengis.ows.v_1_1_0.CodeType;
import net.opengis.wps.v_1_0_0.Execute;
import net.opengis.wps.v_1_0_0.ExecuteResponse;

public class DefaultExecuteService
implements ExecuteService {
    private WpsProcessRegistry wpsProcessRegistry;
    private final String url;

    public DefaultExecuteService(String url) {
        this.url = url;
    }

    public WpsProcessRegistry getWpsProcessRegistry() {
        return this.wpsProcessRegistry;
    }

    public void setWpsProcessRegistry(WpsProcessRegistry wpsProcessRegistry) {
        this.wpsProcessRegistry = wpsProcessRegistry;
    }

    public String getUri() {
        return this.url;
    }

    @Override
    public ExecuteResponse execute(Execute input) throws OwsException {
        CodeType identifier = input.getIdentifier();
        if (identifier == null) {
            throw new MissingParameterValueException("identifier");
        }
        WpsProcess wpsProcess = this.getWpsProcessRegistry().getProcessByIdentifier(identifier);
        if (wpsProcess == null) {
            throw new InvalidParameterValueException("identifier", identifier.getValue());
        }
        ExecuteResponse executeResponse = wpsProcess.execute(input.getDataInputs(), input.getResponseForm(), Locale.ENGLISH.toString());
        executeResponse.setServiceInstance(this.getUri() + "?request=GetCapabilities&service=WPS");
        return executeResponse;
    }
}

