/*
 * Decompiled with CFR 0.152.
 */
package net.disy.commons.xml.datatype;

import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.XMLGregorianCalendar;
import org.directwebremoting.convert.BaseV20Converter;
import org.directwebremoting.dwrp.SimpleOutboundVariable;
import org.directwebremoting.extend.Converter;
import org.directwebremoting.extend.InboundContext;
import org.directwebremoting.extend.InboundVariable;
import org.directwebremoting.extend.MarshallException;
import org.directwebremoting.extend.OutboundContext;
import org.directwebremoting.extend.OutboundVariable;
import org.directwebremoting.util.JavascriptUtil;
import org.directwebremoting.util.LocalUtil;
import org.directwebremoting.util.Logger;

public class XMLGregorianCalendarConverter
extends BaseV20Converter
implements Converter {
    private static final Logger log = Logger.getLogger(XMLGregorianCalendarConverter.class);
    private final DatatypeFactory datatypeFactory;

    public XMLGregorianCalendarConverter() {
        try {
            this.datatypeFactory = DatatypeFactory.newInstance();
        }
        catch (DatatypeConfigurationException dcex) {
            throw new ExceptionInInitializerError(dcex);
        }
    }

    public Object convertInbound(Class paramType, InboundVariable iv, InboundContext inctx) {
        String string = LocalUtil.decode((String)iv.getValue());
        try {
            return this.datatypeFactory.newXMLGregorianCalendar(string);
        }
        catch (IllegalArgumentException iaex) {
            log.warn("Failed to create XMLGregorianCalendar from string [" + string + "]. Returning [null].");
            return null;
        }
    }

    public OutboundVariable convertOutbound(Object data, OutboundContext outctx) throws MarshallException {
        if (data instanceof XMLGregorianCalendar) {
            String escaped = JavascriptUtil.escapeJavaScript((String)data.toString());
            return new SimpleOutboundVariable('\"' + escaped + '\"', outctx, true);
        }
        throw new MarshallException(data.getClass());
    }
}

