/*
 * Decompiled with CFR 0.152.
 */
package net.disy.ogc.wps.v_1_0_0.proxy;

import java.util.Collection;
import java.util.List;
import net.disy.ogc.wps.v_1_0_0.WpsProcess;
import net.disy.ogc.wps.v_1_0_0.WpsProcessRegistry;
import net.disy.ogc.wps.v_1_0_0.proxy.ProxyWpsProcessFactory;

public class ProxyProcessAdder {
    private final ProxyWpsProcessFactory proxyFactory;
    private final WpsProcessRegistry processRegistry;

    public ProxyProcessAdder(WpsProcessRegistry processRegistry, ProxyWpsProcessFactory proxyFactory) {
        this.processRegistry = processRegistry;
        this.proxyFactory = proxyFactory;
    }

    public void addProxyProcesses(List<String> capabilitiesUrls) throws IllegalArgumentException {
        for (String capabilitiesUrl : capabilitiesUrls) {
            this.addProxyProcess(this.proxyFactory, capabilitiesUrl);
        }
    }

    private void addProxyProcess(ProxyWpsProcessFactory proxyFactory, String capabilitiesUrl) throws IllegalArgumentException {
        try {
            if (capabilitiesUrl != null) {
                Collection<WpsProcess> proxyProcesses = proxyFactory.createProxyWpsProcesses(capabilitiesUrl.trim());
                for (WpsProcess proxyProcess : proxyProcesses) {
                    this.processRegistry.registerProcess(proxyProcess);
                }
            }
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Could not create proxy processes for the capabilities URL [" + capabilitiesUrl + "].", e);
        }
    }
}

