/*
 * Decompiled with CFR 0.152.
 */
package net.disy.ogc.wps.v_1_0_0.proxy;

import net.disy.ogc.ows.v_1_1_0.NoApplicableCodeException;
import net.disy.ogc.ows.v_1_1_0.OwsException;
import net.disy.ogc.wps.v_1_0_0.WpsProcess;
import net.disy.ogc.wps.v_1_0_0.proxy.ExceptionHandlingUtils;
import net.disy.ogc.wps.v_1_0_0.proxy.GenericMarshallingHttpClient;
import net.opengis.ows.v_1_1_0.CodeType;
import net.opengis.wps.v_1_0_0.DataInputsType;
import net.opengis.wps.v_1_0_0.Execute;
import net.opengis.wps.v_1_0_0.ExecuteResponse;
import net.opengis.wps.v_1_0_0.ProcessDescriptionType;
import net.opengis.wps.v_1_0_0.ResponseFormType;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ProxyProcess
implements WpsProcess {
    private final Log log = LogFactory.getLog(this.getClass());
    private final CodeType remoteIdentifier;
    private final ProcessDescriptionType ownDescription;
    private final GenericMarshallingHttpClient httpClient;
    private final String executeUrl;

    public ProxyProcess(CodeType proxyId, String executeUrl, ProcessDescriptionType remoteDescription, GenericMarshallingHttpClient httpClient) {
        this.httpClient = httpClient;
        this.remoteIdentifier = remoteDescription.getIdentifier();
        this.ownDescription = (ProcessDescriptionType)remoteDescription.copyTo(remoteDescription.createNewInstance());
        this.ownDescription.setIdentifier(proxyId);
        this.executeUrl = executeUrl;
    }

    public ExecuteResponse execute(DataInputsType dataInputs, ResponseFormType responseForm, String language) throws OwsException {
        Execute execute = this.createProxyExecution(dataInputs, responseForm, language);
        return this.executeInternal(execute);
    }

    public Execute createProxyExecution(DataInputsType dataInputs, ResponseFormType responseForm, String language) {
        Execute execute = new Execute();
        execute.setService("WPS");
        execute.setVersion("1.0.0");
        execute.setLanguage(language);
        execute.setIdentifier(this.remoteIdentifier);
        execute.setDataInputs(dataInputs);
        execute.setResponseForm(responseForm);
        execute.setLanguage(language);
        return execute;
    }

    private ExecuteResponse executeInternal(Execute proxyExecute) throws OwsException {
        Object responseObject;
        ExecuteResponse response = null;
        try {
            responseObject = this.httpClient.executePostRequest(this.executeUrl, proxyExecute);
        }
        catch (Exception e) {
            if (e instanceof OwsException) {
                throw (OwsException)e;
            }
            this.log.error((Object)"Unexpected internal exception happened", (Throwable)e);
            throw new NoApplicableCodeException("Internal error", (Throwable)e);
        }
        response = ExceptionHandlingUtils.handleExceptionReport(responseObject, ExecuteResponse.class);
        if (response != null) {
            response.getProcess().setIdentifier(this.ownDescription.getIdentifier());
        }
        return response;
    }

    public ProcessDescriptionType getProcessDescription() {
        return this.ownDescription;
    }
}

