/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.algorithm;

import com.vividsolutions.jts.geom.Coordinate;

public class VectorMath {
    public static Coordinate normalToTriangle(Coordinate p0, Coordinate p1, Coordinate p2) {
        Coordinate v1 = new Coordinate(p1.x - p0.x, p1.y - p0.y, p1.z - p0.z);
        Coordinate v2 = new Coordinate(p2.x - p0.x, p2.y - p0.y, p2.z - p0.z);
        Coordinate cp = VectorMath.crossProduct(v1, v2);
        VectorMath.normalize(cp);
        return cp;
    }

    public static void normalize(Coordinate v) {
        double absVal = Math.sqrt(v.x * v.x + v.y * v.y + v.z * v.z);
        v.x /= absVal;
        v.y /= absVal;
        v.z /= absVal;
    }

    public static Coordinate crossProduct(Coordinate v1, Coordinate v2) {
        double x = VectorMath.det(v1.y, v1.z, v2.y, v2.z);
        double y = -VectorMath.det(v1.x, v1.z, v2.x, v2.z);
        double z = VectorMath.det(v1.x, v1.y, v2.x, v2.y);
        return new Coordinate(x, y, z);
    }

    public static double dotProduct(Coordinate v1, Coordinate v2) {
        return v1.x * v2.x + v1.y * v2.y + v1.z * v2.z;
    }

    public static double det(double a1, double a2, double b1, double b2) {
        return a1 * b2 - a2 * b1;
    }
}

