/*
 * Decompiled with CFR 0.152.
 */
package net.disy.commons.dwr.convert;

import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import org.directwebremoting.convert.BaseV20Converter;
import org.directwebremoting.dwrp.ParseUtil;
import org.directwebremoting.extend.ConverterManager;
import org.directwebremoting.extend.InboundContext;
import org.directwebremoting.extend.InboundVariable;
import org.directwebremoting.extend.MarshallException;
import org.directwebremoting.extend.OutboundContext;
import org.directwebremoting.extend.OutboundVariable;
import org.directwebremoting.util.Messages;

public abstract class AbstractConverter
extends BaseV20Converter {
    private ConverterManager converterManager;

    protected Map<String, String> extractInboundTokens(Class<?> paramType, String value) throws MarshallException {
        HashMap<String, String> tokens = new HashMap<String, String>();
        StringTokenizer st = new StringTokenizer(value, ",");
        int size = st.countTokens();
        for (int i = 0; i < size; ++i) {
            String token = st.nextToken();
            if (token.trim().length() == 0) continue;
            int colonpos = token.indexOf(":");
            if (colonpos == -1) {
                throw new MarshallException(paramType, Messages.getString((String)"BeanConverter.MissingSeparator", (Object)":", (Object)token));
            }
            String key = token.substring(0, colonpos).trim();
            String val = token.substring(colonpos + 1).trim();
            tokens.put(key, val);
        }
        return tokens;
    }

    public void setConverterManager(ConverterManager converterManager) {
        this.converterManager = converterManager;
    }

    public ConverterManager getConverterManager() {
        return this.converterManager;
    }

    public Object convertInbound(Class paramType, InboundVariable data, InboundContext inctx) throws MarshallException {
        String value = data.getValue();
        if (value.trim().equals("null")) {
            return null;
        }
        if (!value.startsWith("{")) {
            throw new MarshallException(paramType, Messages.getString((String)"BeanConverter.FormatError", (Object)"{"));
        }
        if (!value.endsWith("}")) {
            throw new MarshallException(paramType, Messages.getString((String)"BeanConverter.FormatError", (Object)"{"));
        }
        value = value.substring(1, value.length() - 1);
        Map<String, String> tokens = this.extractInboundTokens(paramType, value);
        return this.convertInbound(paramType, data, tokens, inctx, value);
    }

    protected abstract Object convertInbound(Class var1, InboundVariable var2, Map<String, String> var3, InboundContext var4, String var5) throws MarshallException;

    public OutboundVariable convertOutbound(Object data, OutboundContext outctx) throws MarshallException {
        return null;
    }

    protected <T> T getValue(String name, Class<T> type, InboundVariable data, Map<String, String> tokens, InboundContext inctx) throws MarshallException {
        Object value;
        String valueString = tokens.get(name);
        if (valueString != null) {
            Object valueDraft;
            String[] split = ParseUtil.splitInbound((String)valueString);
            String splitValue = split[1];
            String splitType = split[0];
            InboundVariable nested = new InboundVariable(data.getLookup(), null, splitType, splitValue);
            value = valueDraft = this.getConverterManager().convertInbound(type, nested, inctx, null);
        } else {
            value = null;
        }
        return (T)value;
    }
}

