/*
 * Legato is a configurable, lightweight web mapping client that can be
 * easily embedded into web pages and portals, CMS and individual web
 * applications. Legato is implemented in JavaScript and based on the
 * popular open source library OpenLayers.
 *
 * Copyright (C) 2010  disy Informationssysteme GmbH, http://www.disy.net
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

/**
 * @requires prototype.js
 */

/*
 * The Loading Indicator Class creates a loading indicator over given element
 * which means that this current area reloads something.
 */
FloorSnappingResolver = Class.create({

  /*
   * Standard Constructor
   */
  initialize : function() {
  },

  getSnapPoint : function(layerid, resolution, worldPoint, callback) {
    var snappedPoint = worldPoint.clone();
    snappedPoint.x = Math.floor(worldPoint.x);
    snappedPoint.y = Math.floor(worldPoint.y);
    callback.delay(0, snappedPoint);
  },

  getSnapPoints : function(layerid, resolution, lastPoint, worldPoint, callback) {
    var snappedPoints = [];
    snappedPoints[0] = worldPoint.clone();
    snappedPoints[0].x = Math.floor(worldPoint.x);
    snappedPoints[0].y = Math.floor(worldPoint.y);
    callback.delay(1, snappedPoints);
  }

});