/*
 * Legato is a configurable, lightweight web mapping client that can be
 * easily embedded into web pages and portals, CMS and individual web
 * applications. Legato is implemented in JavaScript and based on the
 * popular open source library OpenLayers.
 *
 * Copyright (C) 2010  disy Informationssysteme GmbH, http://www.disy.net
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

WPS.Component.Point = OpenLayers.Class(WPS.Component.AbstractGeometry, {
  geometryType : 'Point',

  createGeoInputControl : function() {
    return new Legato.Control.DrawPoint(this.layer, {
      title : WPS.I18n.getMessage('WPS.Point.Draw'),
      mode : Legato.Control.DrawFeature.MODE_REPLACE_FEATURE,
      type : OpenLayers.Control.TYPE_TOGGLE,
      style : this.getDefaultStyle()
    });
  },
  createGeoModifyControl : function() {
    return new Legato.Control.ModifyPoint(this.layer, {
      title : WPS.I18n.getMessage('WPS.Point.Edit'),
      mode : Legato.Control.ModifyFeature.MODE_RESHAPE,
      style : this.getDefaultStyle()
    });
  },
  getDefaultStyle : function(){
    return this.getNamedStyle('Point');
  },

  CLASS_NAME : 'WPS.Component.Point'
});